/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.aucom.sound.Speaker;
import org.jaudiotagger.tag.FieldKey;
import org.muplayer.info.AudioTag;
import org.muplayer.info.PlayerData;
import org.muplayer.info.TrackData;
import org.muplayer.info.TrackIO;
import org.muplayer.interfaces.MusicControls;
import org.muplayer.interfaces.PlayerControls;
import org.muplayer.model.TrackInfo;
import org.muplayer.model.trackstates.FinishedState;
import org.muplayer.model.trackstates.KilledState;
import org.muplayer.model.trackstates.PausedState;
import org.muplayer.model.trackstates.PlayingState;
import org.muplayer.model.trackstates.ReverberatedState;
import org.muplayer.model.trackstates.StartedState;
import org.muplayer.model.trackstates.StoppedState;
import org.muplayer.model.trackstates.TrackState;
import org.muplayer.properties.AudioSupportInfo;
import org.muplayer.system.Time;
import org.muplayer.util.AudioUtil;
import org.muplayer.util.FileUtil;
import org.muplayer.util.TrackUtil;

public abstract class Track
extends Thread
implements MusicControls,
TrackInfo {
    protected volatile Object dataSource;
    protected volatile AudioTag tagInfo;
    protected volatile TrackIO trackIO;
    protected volatile TrackData trackData;
    protected volatile TrackState state;
    protected final PlayerControls player;
    protected final AudioSupportInfo audioSupportInfo = AudioSupportInfo.getInstance();

    public static Track getTrack(Object dataSource) {
        return Track.getTrack(dataSource, null);
    }

    public static Track getTrack(Object dataSource, PlayerControls player) {
        if (dataSource instanceof File || dataSource instanceof String) {
            File fileSource;
            File file = fileSource = dataSource instanceof File ? (File)dataSource : new File((String)dataSource);
            if (!fileSource.exists()) {
                return null;
            }
            Track result = null;
            String formatName = FileUtil.getFormatName(fileSource.getName());
            AudioSupportInfo supportManager = AudioSupportInfo.getInstance();
            String formatClass = supportManager.getProperty(formatName);
            if (AudioUtil.isSupported(fileSource)) {
                result = TrackUtil.getTrackFromClass(formatClass, fileSource, player);
            }
            return result;
        }
        if (dataSource instanceof InputStream) {
            InputStream inputStream = (InputStream)dataSource;
            AudioSupportInfo supportManager = AudioSupportInfo.getInstance();
            Set<String> propertyNames = supportManager.getPropertyNames();
            Optional<Track> optionalTrack = propertyNames.stream().map(propName -> TrackUtil.getTrackFromClass(supportManager.getProperty((String)propName), inputStream, player)).filter(Objects::nonNull).findFirst();
            return optionalTrack.orElse(null);
        }
        return null;
    }

    public static boolean isValidTrack(String trackPath) {
        return Track.isValidTrack(new File(trackPath));
    }

    public static boolean isValidTrack(File track) {
        return AudioUtil.isSupported(track);
    }

    public static boolean isValidTrack(Path track) {
        return AudioUtil.isSupported(track);
    }

    protected Track(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(dataSource, null);
    }

    protected Track(InputStream inputStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(inputStream, null);
    }

    protected Track(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath), null);
    }

    protected Track(File dataSource, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.dataSource = dataSource;
        this.trackIO = new TrackIO();
        this.state = new StoppedState(this);
        this.trackData = new TrackData(0.0, 0.0, PlayerData.DEFAULT_VOLUME, false);
        this.player = player;
        this.tagInfo = this.loadTagInfo(dataSource);
        this.setPriority(10);
    }

    protected Track(InputStream inputStream, PlayerControls player) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.dataSource = inputStream;
        this.trackIO = new TrackIO();
        this.state = new StoppedState(this);
        this.trackData = new TrackData(0.0, 0.0, PlayerData.DEFAULT_VOLUME, false);
        this.player = player;
        this.setPriority(10);
    }

    protected Track(String trackPath, PlayerControls player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this(new File(trackPath), player);
    }

    protected abstract void loadAudioStream() throws IOException, UnsupportedAudioFileException;

    public Speaker createLine() throws LineUnavailableException {
        Speaker line = this.trackIO.createLine();
        this.setGain(this.trackData.getVolume());
        return line;
    }

    public void initLine() throws LineUnavailableException {
        boolean initialized = this.trackIO.initLine();
        if (initialized) {
            this.setGain(this.trackData.getVolume());
        }
    }

    public void closeAllStreams() {
        boolean closed = this.trackIO.closeAllStreams();
        if (closed) {
            this.trackData.setSecsSeeked(0.0);
        }
    }

    public void initAll() throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.loadAudioStream();
        this.initLine();
    }

    public void resetStream() throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this.closeAllStreams();
        this.initAll();
    }

    public void validateTrack() throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (!this.trackIO.isTrackStreamsOpened()) {
            this.initAll();
            this.closeAllStreams();
        }
    }

    protected AudioTag loadTagInfo(File dataSource) {
        try {
            AudioTag audioTag = new AudioTag(dataSource);
            return audioTag.isValidFile() ? audioTag : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public TrackIO getTrackIO() {
        return this.trackIO;
    }

    public TrackData getTrackData() {
        return this.trackData;
    }

    public TrackState getTrackState() {
        return this.state;
    }

    public String getStateToString() {
        return this.state.getName();
    }

    public PlayerControls getPlayer() {
        return this.player;
    }

    public File getDataSourceAsFile() {
        return this.dataSource instanceof File ? (File)this.dataSource : null;
    }

    public InputStream getDataSourceAsStream() {
        return this.dataSource instanceof InputStream ? (InputStream)this.dataSource : null;
    }

    public URL getDataSourceAsURL() {
        return this.dataSource instanceof URL ? (URL)this.dataSource : null;
    }

    public AudioTag getTagInfo() {
        return this.tagInfo;
    }

    protected abstract double convertSecondsToBytes(Number var1);

    protected abstract double convertBytesToSeconds(Number var1);

    @Override
    public synchronized double getProgress() {
        return this.trackIO.getSecondsPosition() + this.trackData.getSecsSeeked();
    }

    public synchronized String getFormattedProgress() {
        String progress = Time.getInstance().getTimeFormatter().format((long)this.getProgress());
        String duration = this.getFormattedDuration();
        return progress + "/" + duration;
    }

    public AudioFileFormat getFileFormat() throws IOException, UnsupportedAudioFileException {
        return this.trackIO.getAudioFileFormat(this.dataSource);
    }

    @Override
    public synchronized boolean isPlaying() {
        return this.state instanceof PlayingState;
    }

    @Override
    public synchronized boolean isPaused() {
        return this.state instanceof PausedState;
    }

    @Override
    public synchronized boolean isStopped() {
        return this.state instanceof StoppedState;
    }

    @Override
    public synchronized boolean isFinished() {
        return this.state instanceof FinishedState;
    }

    public synchronized boolean isKilled() {
        return this.state instanceof KilledState;
    }

    @Override
    public boolean isMute() {
        return this.trackData.isMute();
    }

    @Override
    public void play() {
        if (this.isAlive()) {
            this.state = new PlayingState(this);
        }
    }

    @Override
    public void pause() {
        if (this.isPlaying()) {
            this.state = new PausedState(this);
        }
    }

    @Override
    public void resumeTrack() {
        if (this.isAlive() && (this.isPaused() || this.isStopped())) {
            this.play();
            this.resume();
        }
    }

    @Override
    public synchronized void stopTrack() {
        if (this.isAlive() && (this.isPlaying() || this.isPaused())) {
            this.state = new StoppedState(this);
        }
    }

    @Override
    public void finish() {
        this.state = new FinishedState(this);
    }

    public void kill() {
        this.state = new KilledState(this);
    }

    @Override
    public synchronized void seek(double seconds) throws IOException {
        if (seconds > 0.0) {
            long bytesToSeek = Math.round(this.convertSecondsToBytes(seconds));
            long skip = this.trackIO.getDecodedStream().skip(bytesToSeek);
            double skippedSeconds = this.convertBytesToSeconds(skip);
            if (skip > 0L) {
                this.trackData.setSecsSeeked(this.trackData.getSecsSeeked() + skippedSeconds);
            }
        } else if (seconds < 0.0) {
            try {
                this.gotoSecond(this.getProgress() + seconds);
            }
            catch (LineUnavailableException | UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void gotoSecond(double second) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        double progress = this.getProgress();
        if (second >= progress) {
            int duration = (int)this.getDuration();
            if (second > (double)duration) {
                second = duration;
            }
            int gt = (int)Math.round(second - this.getProgress());
            this.seek(gt);
        } else {
            this.state = new ReverberatedState(this, second);
        }
    }

    @Override
    public float getGain() {
        return this.trackData.isMute() ? 0.0f : this.trackData.getVolume();
    }

    @Override
    public void setGain(float volume) {
        if (this.trackIO.isTrackStreamsOpened()) {
            this.trackData.setVolume(volume > 100.0f ? 100.0f : (volume < 0.0f ? 0.0f : volume));
            if (this.trackIO.getTrackLine() != null) {
                this.trackIO.getTrackLine().setGain(AudioUtil.convertVolRangeToLineRange(volume));
            }
            this.trackData.setMute(this.trackData.getVolume() == 0.0f);
        }
    }

    @Override
    public void mute() {
        if (this.trackIO.isTrackStreamsOpened() && !this.trackData.isMute()) {
            this.trackData.setMute(true);
            if (this.trackIO.getTrackLine() != null) {
                this.trackIO.getTrackLine().setGain(AudioUtil.convertVolRangeToLineRange(0.0f));
            }
        }
    }

    @Override
    public void unMute() {
        if (this.trackIO.isTrackStreamsOpened() && this.trackData.isMute()) {
            this.trackData.setMute(false);
            this.setGain(this.trackData.getVolume());
        }
    }

    @Override
    public boolean hasCover() {
        return this.tagInfo != null && this.tagInfo.getCover() != null;
    }

    @Override
    public String getProperty(String key) {
        return this.tagInfo == null ? null : this.tagInfo.getTag(key);
    }

    @Override
    public String getProperty(FieldKey key) {
        return this.tagInfo != null ? this.tagInfo.getTag(key) : null;
    }

    @Override
    public String getTitle() {
        String titleProper = this.getProperty(FieldKey.TITLE);
        File fileSource = this.dataSource != null && this.dataSource instanceof File ? (File)this.dataSource : null;
        return (titleProper == null || titleProper.trim().isEmpty()) && fileSource != null ? fileSource.getName() : titleProper;
    }

    @Override
    public String getAlbum() {
        return this.getProperty(FieldKey.ALBUM);
    }

    @Override
    public String getArtist() {
        return this.getProperty(FieldKey.ARTIST);
    }

    @Override
    public String getDate() {
        return this.getProperty(FieldKey.YEAR);
    }

    @Override
    public byte[] getCoverData() {
        return this.tagInfo != null ? this.tagInfo.getCoverData() : null;
    }

    @Override
    public long getDuration() {
        return this.tagInfo != null ? (long)this.tagInfo.getDuration() : 0L;
    }

    @Override
    public String getEncoder() {
        return this.getProperty(FieldKey.ENCODER);
    }

    @Override
    public String getBitrate() {
        return this.tagInfo != null && this.tagInfo.getHeader() != null ? this.tagInfo.getHeader().getBitRate() : "Unknown";
    }

    public String getFormat() {
        return this.trackIO.getDecodedStream().getFormat().toString();
    }

    public void getLineInfo() {
        SourceDataLine driver = this.trackIO.getTrackLine().getDriver();
        System.out.println("Soporte de controles en line");
        System.out.println("---------------");
        System.out.println("Pan: " + driver.isControlSupported(FloatControl.Type.PAN));
        System.out.println("AuxReturn: " + driver.isControlSupported(FloatControl.Type.AUX_RETURN));
        System.out.println("AuxSend: " + driver.isControlSupported(FloatControl.Type.AUX_SEND));
        System.out.println("Balance: " + driver.isControlSupported(FloatControl.Type.BALANCE));
        System.out.println("ReverbReturn: " + driver.isControlSupported(FloatControl.Type.REVERB_RETURN));
        System.out.println("ReberbSend: " + driver.isControlSupported(FloatControl.Type.REVERB_SEND));
        System.out.println("Volume: " + driver.isControlSupported(FloatControl.Type.VOLUME));
        System.out.println("SampleRate: " + driver.isControlSupported(FloatControl.Type.SAMPLE_RATE));
        System.out.println("MasterGain: " + driver.isControlSupported(FloatControl.Type.MASTER_GAIN));
    }

    @Override
    public void run() {
        try {
            this.initAll();
            this.state = new StartedState(this);
            while (this.state.canTrackContinue()) {
                this.state.execute();
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }
}

