/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.info;

import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.datatype.Artwork;
import org.muplayer.info.AudioTag;
import org.muplayer.model.TrackInfo;

public class SongData
implements TrackInfo {
    private final AudioTag info;

    public SongData(AudioTag tag) {
        this.info = tag;
    }

    @Override
    public boolean hasCover() {
        return this.info.hasCover();
    }

    @Override
    public String getProperty(String key) {
        return this.info.getTag(key);
    }

    @Override
    public String getProperty(FieldKey key) {
        return this.info.getTag(key);
    }

    @Override
    public String getTitle() {
        String title = this.info.getTag(FieldKey.TITLE);
        if (title == null) {
            title = this.info.getFileSource().getName();
        }
        return title;
    }

    @Override
    public String getAlbum() {
        String album = this.info.getTag(FieldKey.ALBUM);
        if (album == null) {
            album = "Album Desconocido";
        }
        return album;
    }

    @Override
    public String getArtist() {
        String artist = this.info.getTag(FieldKey.ARTIST);
        if (artist == null) {
            artist = "Artista Desconocido";
        }
        return artist;
    }

    @Override
    public String getDate() {
        return this.info.getTag(FieldKey.YEAR);
    }

    @Override
    public byte[] getCoverData() {
        Artwork cover = this.info.getCover();
        return cover == null ? null : cover.getBinaryData();
    }

    @Override
    public long getDuration() {
        return this.info.getDuration();
    }

    @Override
    public String getEncoder() {
        return this.info.getTag(FieldKey.ENCODER);
    }

    @Override
    public String getBitrate() {
        return this.info.getHeader().getBitRate();
    }

    public String toString() {
        return "SongData: " + this.getTitle();
    }
}

