/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.info;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.aucom.sound.Speaker;

public class TrackIO {
    private volatile Speaker trackLine;
    private volatile AudioInputStream decodedStream;
    private volatile AudioFileReader audioReader;

    public synchronized boolean hasValidTrackLine() {
        return this.trackLine != null;
    }

    public void resetLine() throws LineUnavailableException {
        this.trackLine.stop();
        this.trackLine.open();
    }

    public Speaker createLine() throws LineUnavailableException {
        Speaker line = new Speaker(this.decodedStream.getFormat());
        line.open();
        return line;
    }

    public boolean initLine() throws LineUnavailableException {
        if (this.decodedStream != null) {
            if (this.trackLine != null) {
                this.trackLine.stop();
                this.trackLine.close();
            }
            try {
                this.trackLine = this.createLine();
                return true;
            }
            catch (IllegalArgumentException e1) {
                System.err.println("Error: " + e1.getMessage());
                return false;
            }
        }
        System.out.println("TrackStream & TrackLine null");
        return false;
    }

    public void closeLine() {
        if (this.trackLine != null) {
            this.trackLine.stop();
            this.trackLine.close();
            this.trackLine = null;
        }
    }

    public boolean closeAllStreams() {
        this.closeLine();
        try {
            this.decodedStream.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public double getSecondsPosition() {
        if (this.trackLine == null) {
            return 0.0;
        }
        return (double)this.trackLine.getDriver().getMicrosecondPosition() / 1000000.0;
    }

    public boolean isTrackStreamsOpened() {
        return this.decodedStream != null && this.trackLine != null;
    }

    public AudioFileFormat getAudioFileFormat(Object dataSource) throws IOException, UnsupportedAudioFileException {
        if (this.audioReader != null && dataSource != null) {
            if (dataSource instanceof File) {
                return this.audioReader.getAudioFileFormat((File)dataSource);
            }
            if (dataSource instanceof InputStream) {
                return this.audioReader.getAudioFileFormat((InputStream)dataSource);
            }
            return this.audioReader.getAudioFileFormat((URL)dataSource);
        }
        return null;
    }

    public AudioFormat getAudioFormat() {
        return this.decodedStream.getFormat();
    }

    public Speaker getTrackLine() {
        return this.trackLine;
    }

    public AudioInputStream getDecodedStream() {
        return this.decodedStream;
    }

    public AudioFileReader getAudioReader() {
        return this.audioReader;
    }

    public void setTrackLine(Speaker trackLine) {
        this.trackLine = trackLine;
    }

    public void setDecodedStream(AudioInputStream decodedStream) {
        this.decodedStream = decodedStream;
    }

    public void setAudioReader(AudioFileReader audioReader) {
        this.audioReader = audioReader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackIO)) {
            return false;
        }
        TrackIO other = (TrackIO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Speaker this$trackLine = this.getTrackLine();
        Speaker other$trackLine = other.getTrackLine();
        if (this$trackLine == null ? other$trackLine != null : !this$trackLine.equals(other$trackLine)) {
            return false;
        }
        AudioInputStream this$decodedStream = this.getDecodedStream();
        AudioInputStream other$decodedStream = other.getDecodedStream();
        if (this$decodedStream == null ? other$decodedStream != null : !this$decodedStream.equals(other$decodedStream)) {
            return false;
        }
        AudioFileReader this$audioReader = this.getAudioReader();
        AudioFileReader other$audioReader = other.getAudioReader();
        return !(this$audioReader == null ? other$audioReader != null : !this$audioReader.equals(other$audioReader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackIO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Speaker $trackLine = this.getTrackLine();
        result = result * 59 + ($trackLine == null ? 43 : $trackLine.hashCode());
        AudioInputStream $decodedStream = this.getDecodedStream();
        result = result * 59 + ($decodedStream == null ? 43 : $decodedStream.hashCode());
        AudioFileReader $audioReader = this.getAudioReader();
        result = result * 59 + ($audioReader == null ? 43 : $audioReader.hashCode());
        return result;
    }

    public String toString() {
        return "TrackIO(trackLine=" + this.getTrackLine() + ", decodedStream=" + this.getDecodedStream() + ", audioReader=" + this.getAudioReader() + ")";
    }

    public TrackIO() {
    }

    public TrackIO(Speaker trackLine, AudioInputStream decodedStream, AudioFileReader audioReader) {
        this.trackLine = trackLine;
        this.decodedStream = decodedStream;
        this.audioReader = audioReader;
    }
}

