/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.muplayer.util.IOUtil;

public class HelpInfo {
    private final Properties properties = new Properties();
    private static final HelpInfo instance = new HelpInfo();

    public static HelpInfo getInstance() {
        return instance;
    }

    private HelpInfo() {
        this.loadData();
    }

    private void loadData() {
        try {
            byte[] resourceBytes = IOUtil.getBytesFromStream(this.getClass().getResourceAsStream("/help.properties"));
            this.properties.load(new ByteArrayInputStream(resourceBytes));
            System.out.println("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key).toString();
    }

    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

