/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import org.muplayer.util.AudioUtil;

public class AudioHardware {
    public static List<Mixer> getMixers() {
        return Arrays.stream(AudioSystem.getMixerInfo()).map(AudioSystem::getMixer).collect(Collectors.toList());
    }

    public static boolean open(Line line) {
        if (line.isOpen()) {
            return false;
        }
        try {
            line.open();
        }
        catch (LineUnavailableException ex) {
            return false;
        }
        return true;
    }

    private static Control findControl(Control.Type type, Control ... controls) {
        if (controls == null || controls.length == 0) {
            return null;
        }
        for (Control control : controls) {
            CompoundControl compoundControl;
            Control member;
            if (control.getType().equals(type)) {
                return control;
            }
            if (!(control instanceof CompoundControl) || (member = AudioHardware.findControl(type, (compoundControl = (CompoundControl)control).getMemberControls())) == null) continue;
            return member;
        }
        return null;
    }

    public static List<Control> getAllControls(Line line) throws LineUnavailableException {
        ArrayList<Control> listControls = new ArrayList<Control>();
        boolean opened = false;
        if (!line.isOpen()) {
            line.open();
            opened = true;
        }
        AudioHardware.findAllControls(listControls, line.getControls());
        if (opened) {
            line.close();
        }
        return listControls;
    }

    public static void findAllControls(List<Control> listControls, Control ... controls) {
        if (controls != null && controls.length > 0) {
            for (int i = 0; i < controls.length; ++i) {
                Control control = controls[i];
                if (control instanceof CompoundControl) {
                    CompoundControl compoundControl = (CompoundControl)control;
                    AudioHardware.findAllControls(listControls, compoundControl.getMemberControls());
                    continue;
                }
                listControls.add(control);
            }
        }
    }

    public static List<DataLine.Info> getAllSpeakerInfo() {
        LinkedList<DataLine.Info> listInfo = new LinkedList<DataLine.Info>();
        Mixer.Info[] mixersInfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixersInfo.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixersInfo[i]);
            Line.Info[] speakersInfo = mixer.getSourceLineInfo();
            for (int j = 0; j < speakersInfo.length; ++j) {
                Line.Info sourceLineInfo = speakersInfo[j];
                if (!(sourceLineInfo instanceof DataLine.Info)) continue;
                listInfo.add((DataLine.Info)sourceLineInfo);
            }
        }
        return listInfo;
    }

    public static List<DataLine.Info> getAllMicrophoneInfo() {
        LinkedList<DataLine.Info> listInfo = new LinkedList<DataLine.Info>();
        Mixer.Info[] mixersInfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixersInfo.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixersInfo[i]);
            Line.Info[] microInfo = mixer.getTargetLineInfo();
            for (int j = 0; j < microInfo.length; ++j) {
                Line.Info targetLineInfo = microInfo[j];
                if (!(targetLineInfo instanceof DataLine.Info)) continue;
                listInfo.add((DataLine.Info)targetLineInfo);
            }
        }
        return listInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Float getMasterOutputVolume() {
        Line line = AudioHardware.getMasterOutputLine();
        if (line == null) {
            return null;
        }
        boolean opened = AudioHardware.open(line);
        try {
            FloatControl control = AudioHardware.getVolumeControl(line);
            Float f = control != null ? Float.valueOf(control.getValue()) : null;
            return f;
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMasterOutputVolume(float value) {
        if (value < 0.0f || value > 1.0f) {
            throw new IllegalArgumentException("Volume can only be set to a value from 0 to 1. Given value is illegal: " + value);
        }
        Line line = AudioHardware.getMasterOutputLine();
        if (line == null) {
            throw new RuntimeException("Master output port not found");
        }
        boolean opened = AudioHardware.open(line);
        try {
            FloatControl control = AudioHardware.getVolumeControl(line);
            if (control == null) {
                throw new RuntimeException("Volume control not found in master port: " + AudioHardware.toString(line));
            }
            control.setValue(value);
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    public static FloatControl getReadyVolumeControl() {
        Line master = AudioHardware.getMasterOutputLine();
        try {
            master.open();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        return AudioHardware.getVolumeControl(master);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean getMasterOutputMute() {
        Line line = AudioHardware.getMasterOutputLine();
        if (line == null) {
            return null;
        }
        boolean opened = AudioHardware.open(line);
        try {
            BooleanControl control = AudioHardware.getMuteControl(line);
            Boolean bl = control != null ? Boolean.valueOf(control.getValue()) : null;
            return bl;
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMasterOutputMute(boolean value) {
        Line line = AudioHardware.getMasterOutputLine();
        if (line == null) {
            throw new RuntimeException("Master output port not found");
        }
        boolean opened = AudioHardware.open(line);
        try {
            BooleanControl control = AudioHardware.getMuteControl(line);
            if (control == null) {
                throw new RuntimeException("Mute control not found in master port: " + AudioHardware.toString(line));
            }
            control.setValue(value);
        }
        finally {
            if (opened) {
                line.close();
            }
        }
    }

    public static Line getMasterOutputLine() {
        for (Mixer mixer : AudioHardware.getMixers()) {
            for (Line line : AudioHardware.getAvailableOutputLines(mixer)) {
                if (!line.getLineInfo().toString().contains("Master")) continue;
                return line;
            }
        }
        return null;
    }

    public static Line getSpeakerInUse() throws LineUnavailableException {
        String headphone = "Headphone";
        String speaker = "Speaker";
        Line headphoneLine = AudioHardware.getMixers().parallelStream().map(mixer -> AudioHardware.getAvailableOutputLines(mixer).parallelStream().filter(line -> line.getLineInfo().toString().contains("Headphone")).findFirst().orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
        Line speakerLine = AudioHardware.getMixers().parallelStream().map(mixer -> AudioHardware.getAvailableOutputLines(mixer).parallelStream().filter(line -> line.getLineInfo().toString().contains("Speaker")).findFirst().orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
        if (headphoneLine == null || speakerLine == null) {
            if (headphoneLine == null && speakerLine == null) {
                return null;
            }
            return Objects.requireNonNullElse(headphoneLine, speakerLine);
        }
        headphoneLine.open();
        BooleanControl headphoneMute = AudioHardware.getMuteControl(headphoneLine);
        speakerLine.open();
        BooleanControl speakerMute = AudioHardware.getMuteControl(speakerLine);
        System.out.println("HeadphoneLine: " + Arrays.toString(headphoneLine.getControls()));
        System.out.println("SpeakerLine: " + Arrays.toString(speakerLine.getControls()));
        Line toReturn = headphoneMute.getValue() && speakerMute.getValue() ? AudioHardware.getMasterOutputLine() : (headphoneMute.getValue() ? speakerLine : headphoneLine);
        headphoneLine.close();
        speakerLine.close();
        toReturn.open();
        return toReturn;
    }

    public static FloatControl getGainControl(Line line) {
        if (!line.isOpen()) {
            throw new RuntimeException("Line is closed: " + AudioHardware.toString(line));
        }
        return (FloatControl)AudioHardware.findControl(FloatControl.Type.MASTER_GAIN, line.getControls());
    }

    public static FloatControl getVolumeControl(Line line) {
        if (!line.isOpen()) {
            throw new RuntimeException("Line is closed: " + AudioHardware.toString(line));
        }
        return (FloatControl)AudioHardware.findControl(FloatControl.Type.VOLUME, line.getControls());
    }

    public static BooleanControl getMuteControl(Line line) {
        if (!line.isOpen()) {
            throw new RuntimeException("Line is closed: " + AudioHardware.toString(line));
        }
        return (BooleanControl)AudioHardware.findControl(BooleanControl.Type.MUTE, line.getControls());
    }

    public static void setMuteValue(Line line, boolean mute) {
        if (!line.isOpen()) {
            throw new RuntimeException("Line is closed: " + AudioHardware.toString(line));
        }
        BooleanControl muteControl = (BooleanControl)AudioHardware.findControl(BooleanControl.Type.MUTE, line.getControls());
        if (muteControl != null) {
            muteControl.setValue(mute);
        }
    }

    public static void setSpeakerMuteValue(boolean mute) {
        try {
            Line speakerInUse = AudioHardware.getSpeakerInUse();
            if (!speakerInUse.isOpen()) {
                speakerInUse.open();
            }
            AudioHardware.setMuteValue(speakerInUse, mute);
            speakerInUse.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float getFormattedMasterVolume() {
        FloatControl volumeControl = AudioHardware.getReadyVolumeControl();
        return AudioUtil.convertLineRangeToVolRange(volumeControl.getValue(), volumeControl);
    }

    public static void setFormattedMasterVolume(float volume) {
        FloatControl volumeControl = AudioHardware.getReadyVolumeControl();
        volumeControl.setValue(AudioUtil.convertVolRangeToLineRange(volume, volumeControl));
    }

    public static float getFormattedSpeakerVolume() {
        try {
            Line speaker = AudioHardware.getSpeakerInUse();
            FloatControl volumeControl = AudioHardware.getVolumeControl(speaker);
            return AudioUtil.convertLineRangeToVolRange(volumeControl.getValue(), volumeControl);
        }
        catch (LineUnavailableException e) {
            return 0.0f;
        }
    }

    public static void setFormattedSpeakerVolume(float volume) {
        try {
            Line speaker = AudioHardware.getSpeakerInUse();
            FloatControl volumeControl = AudioHardware.getVolumeControl(speaker);
            volumeControl.setValue(AudioUtil.convertVolRangeToLineRange(volume, volumeControl));
        }
        catch (LineUnavailableException lineUnavailableException) {
            // empty catch block
        }
    }

    public static List<Line> getAvailableOutputLines(Mixer mixer) {
        return AudioHardware.getAvailableLines(mixer, mixer.getTargetLineInfo());
    }

    public static List<Line> getAvailableInputLines(Mixer mixer) {
        return AudioHardware.getAvailableLines(mixer, mixer.getSourceLineInfo());
    }

    private static List<Line> getAvailableLines(Mixer mixer, Line.Info[] lineInfos) {
        LinkedList<Line> lines = new LinkedList<Line>();
        for (int i = 0; i < lineInfos.length; ++i) {
            Line.Info lineInfo = lineInfos[i];
            Line line = AudioHardware.getLineIfAvailable(mixer, lineInfo);
            if (line == null) continue;
            lines.add(line);
        }
        return lines;
    }

    public static Line getLineIfAvailable(Mixer mixer, Line.Info lineInfo) {
        try {
            return mixer.getLine(lineInfo);
        }
        catch (LineUnavailableException ex) {
            return null;
        }
    }

    public static void getLineInfo(Line line, StringBuilder sb, boolean opened) {
        for (Control control : line.getControls()) {
            sb.append("    Control: ").append(AudioHardware.toString(control)).append("\n");
            if (!(control instanceof CompoundControl)) continue;
            CompoundControl compoundControl = (CompoundControl)control;
            for (Control subControl : compoundControl.getMemberControls()) {
                sb.append("      Sub-Control: ").append(AudioHardware.toString(subControl)).append("\n");
            }
        }
        if (opened) {
            line.close();
        }
    }

    public static String getHierarchyInfo() {
        StringBuilder sb = new StringBuilder();
        for (Mixer mixer : AudioHardware.getMixers()) {
            boolean opened;
            sb.append("Mixer: ").append(AudioHardware.toString(mixer)).append("\n");
            for (Line line : AudioHardware.getAvailableOutputLines(mixer)) {
                sb.append("  OUT: ").append(AudioHardware.toString(line)).append("\n");
                opened = AudioHardware.open(line);
                AudioHardware.getLineInfo(line, sb, opened);
            }
            for (Line line : AudioHardware.getAvailableOutputLines(mixer)) {
                sb.append("  IN: ").append(AudioHardware.toString(line)).append("\n");
                opened = AudioHardware.open(line);
                AudioHardware.getLineInfo(line, sb, opened);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Control control) {
        return control != null ? control.toString() + " (" + control.getType().toString() + ")" : null;
    }

    public static String toString(Line line) {
        return line != null ? line.getLineInfo().toString() : null;
    }

    public static String toString(Mixer mixer) {
        if (mixer == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Mixer.Info info = mixer.getMixerInfo();
        sb.append(info.getName());
        sb.append(" (").append(info.getDescription()).append(")");
        sb.append(mixer.isOpen() ? " [open]" : " [closed]");
        return sb.toString();
    }
}

