/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track.states;

import org.muplayer.audio.track.Track;

public abstract class TrackState {
    protected final Track track;
    protected volatile boolean canTrackContinue;
    protected volatile Runnable preTask;

    public TrackState(Track track) {
        this.track = track;
        this.canTrackContinue = true;
    }

    public boolean canTrackContinue() {
        return this.canTrackContinue;
    }

    public Runnable getPreTask() {
        return this.preTask;
    }

    public void setPreTask(Runnable preTask) {
        this.preTask = preTask;
    }

    public String getName() {
        String className = this.getClass().getSimpleName();
        return className.replace("State", "").trim();
    }

    public void execute() {
        if (this.preTask != null) {
            this.preTask.run();
        }
        this.handle();
    }

    public abstract void handle();

    public synchronized void finish() {
        this.canTrackContinue = false;
    }
}

