/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.bytebuffer.ByteBuffer;
import org.muplayer.util.DataUtil;

public class IOUtil {
    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        int read;
        ByteBuffer byteBuffer = new ByteBuffer();
        while ((read = inputStream.read()) != -1) {
            byteBuffer.add(read);
        }
        return byteBuffer.toArray();
    }

    public static String getAsciiStringFromStream(InputStream inputStream) throws IOException {
        byte[] buffer = IOUtil.getBytesFromStream(inputStream);
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public static byte[] getBytesFromPath(String path) throws IOException {
        return Files.readAllBytes(new File(path).toPath());
    }

    public static byte[] getBytesFromRes(String path) throws IOException {
        return IOUtil.getBytesFromStream(DataUtil.getResourceAsStream(path));
    }

    public static InputStream getArrayStreamFromPath(String path) throws IOException {
        return new ByteArrayInputStream(IOUtil.getBytesFromPath(path));
    }

    public static InputStream getArrayStreamFromRes(String path) throws IOException {
        return new ByteArrayInputStream(IOUtil.getBytesFromRes(path));
    }
}

