/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

public class TrackData {
    private volatile double secsSeeked;
    private volatile double bytesPerSecond;
    private volatile float volume;
    private volatile boolean isMute;

    public float getGain() {
        return this.isMute ? 0.0f : this.volume;
    }

    public double getSecsSeeked() {
        return this.secsSeeked;
    }

    public double getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isMute() {
        return this.isMute;
    }

    public void setSecsSeeked(double secsSeeked) {
        this.secsSeeked = secsSeeked;
    }

    public void setBytesPerSecond(double bytesPerSecond) {
        this.bytesPerSecond = bytesPerSecond;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setMute(boolean isMute) {
        this.isMute = isMute;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackData)) {
            return false;
        }
        TrackData other = (TrackData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSecsSeeked(), other.getSecsSeeked()) != 0) {
            return false;
        }
        if (Double.compare(this.getBytesPerSecond(), other.getBytesPerSecond()) != 0) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        return this.isMute() == other.isMute();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $secsSeeked = Double.doubleToLongBits(this.getSecsSeeked());
        result = result * 59 + (int)($secsSeeked >>> 32 ^ $secsSeeked);
        long $bytesPerSecond = Double.doubleToLongBits(this.getBytesPerSecond());
        result = result * 59 + (int)($bytesPerSecond >>> 32 ^ $bytesPerSecond);
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + (this.isMute() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TrackData(secsSeeked=" + this.getSecsSeeked() + ", bytesPerSecond=" + this.getBytesPerSecond() + ", volume=" + this.getVolume() + ", isMute=" + this.isMute() + ")";
    }

    public TrackData() {
    }

    public TrackData(double secsSeeked, double bytesPerSecond, float volume, boolean isMute) {
        this.secsSeeked = secsSeeked;
        this.bytesPerSecond = bytesPerSecond;
        this.volume = volume;
        this.isMute = isMute;
    }
}

