/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.console;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.player.Player;
import org.muplayer.console.ConsoleExecution;
import org.muplayer.console.ConsoleInterpreter;
import org.muplayer.system.SysInfo;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public class ConsoleRunner
extends Thread {
    protected final Player player;
    protected final ConsoleInterpreter interpreter;
    protected final Scanner scanner;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsoleRunner() throws FileNotFoundException {
        this.player = new MusicPlayer((File)null);
        this.interpreter = new ConsoleInterpreter(this.player);
        this.scanner = new Scanner(System.in);
    }

    public ConsoleRunner(File rootFolder) throws FileNotFoundException {
        this.player = new MusicPlayer(rootFolder);
        this.interpreter = new ConsoleInterpreter(this.player);
        this.scanner = new Scanner(System.in);
    }

    public ConsoleRunner(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    public ConsoleRunner(MusicPlayer player) throws FileNotFoundException {
        this.player = player;
        this.interpreter = new ConsoleInterpreter(player);
        this.scanner = new Scanner(System.in);
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger((Object)this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger((Object)this, (String)e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public ConsoleExecution execCommand(String strCmd) {
        try {
            return this.interpreter.executeCommand(strCmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void run() {
        String appVersion = SysInfo.readVersion();
        Object msg = appVersion != null ? "MuPlayer v" + appVersion + " started..." : "MuPlayer started...";
        Logger.getLogger((Object)this, (Object)msg).rawInfo();
        this.interpreter.setOn(true);
        while (this.interpreter.isOn()) {
            ConsoleExecution consoleExecution;
            this.printHeader();
            String cmd = this.scanner.nextLine().trim();
            if (cmd.isEmpty() || !(consoleExecution = this.execCommand(cmd)).hasOutput()) continue;
            System.out.println(consoleExecution.getOutputMsg());
        }
        System.exit(0);
    }

    public Player getPlayer() {
        return this.player;
    }
}

