/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.console.ConsoleRunner;
import org.muplayer.net.DaemonRunner;
import org.muplayer.properties.ConfigInfo;
import org.muplayer.properties.MessagesInfo;
import org.muplayer.thread.TaskRunner;

public class MuPlayer {
    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                String defaultRootPath = ConfigInfo.getInstance().get("root_folder");
                if (defaultRootPath == null) {
                    throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                }
                TaskRunner.execute(new ConsoleRunner(defaultRootPath));
            } else {
                switch (args.length) {
                    case 1: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                        }
                        TaskRunner.execute(new ConsoleRunner(firstArg));
                        break;
                    }
                    case 2: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            if (firstArg.equals("-l")) {
                                TaskRunner.execute(new ConsoleRunner(args[1]));
                                break;
                            }
                            if (firstArg.equals("-d")) {
                                TaskRunner.execute(new DaemonRunner(new MusicPlayer(args[1])));
                                break;
                            }
                            throw new NullPointerException("Arg " + firstArg + "not recognized");
                        }
                        throw new NullPointerException("Arg " + firstArg + "not recognized");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

