/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.console.runner;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.player.Player;
import org.muplayer.console.runner.ConsoleRunner;
import org.muplayer.net.DaemonServer;
import org.muplayer.net.TCPClient;
import org.muplayer.system.Global;
import org.muplayer.system.GlobalVar;
import org.orangelogger.sys.Logger;

public class DaemonRunner
extends ConsoleRunner {
    private final DaemonServer daemonServer = new DaemonServer();

    public DaemonRunner() throws IOException {
        this((File)null);
    }

    public DaemonRunner(String folder) throws IOException {
        this(new File(folder));
    }

    public DaemonRunner(File rootFolder) throws IOException {
        this(new MusicPlayer(rootFolder));
    }

    public DaemonRunner(Player player) throws IOException {
        super(player);
    }

    public void shutdown() throws IOException {
        this.interpreter.setOn(false);
        this.daemonServer.shutdownServer();
    }

    @Override
    public void run() {
        Logger.getLogger((Object)this, (Object)"MuPlayer daemon mode started.").info();
        this.interpreter.setOn(true);
        Socket reqSocket = null;
        Logger.getLogger((Object)this, (Object)"Waiting clients...").info();
        while (this.interpreter.isOn() && this.daemonServer.isAlive()) {
            try {
                reqSocket = this.daemonServer.getRequestSocket();
                if (reqSocket != null) {
                    this.daemonServer.addClient(new TCPClient(this.interpreter, reqSocket));
                    Logger.getLogger((Object)this, (Object)("Client connected from IP " + reqSocket.getRemoteSocketAddress().toString())).info();
                    Logger.getLogger((Object)this, (Object)"Waiting clients...").info();
                }
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Logger.getLogger((Object)this, (Object)"Daemon server closed!");
        try {
            this.daemonServer.shutdownServer();
            ConsoleRunner runner = (ConsoleRunner)Global.getInstance().getVar(GlobalVar.RUNNER);
            if (runner == null || runner instanceof DaemonRunner) {
                System.exit(0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

