/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.main;

import org.muplayer.console.runner.ConsoleRunner;
import org.muplayer.console.runner.DaemonRunner;
import org.muplayer.console.runner.LocalRunner;
import org.muplayer.properties.ConfigInfo;
import org.muplayer.properties.MessagesInfo;
import org.muplayer.system.Global;
import org.muplayer.system.GlobalVar;
import org.muplayer.thread.TaskRunner;

public class MuPlayer {
    public static void main(String[] args) {
        try {
            ConsoleRunner consoleRunner = null;
            if (args.length == 0) {
                String defaultRootPath = ConfigInfo.getInstance().get("root_folder");
                if (defaultRootPath == null) {
                    throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                }
                consoleRunner = new LocalRunner(defaultRootPath);
            } else {
                switch (args.length) {
                    case 1: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                        }
                        consoleRunner = new LocalRunner(firstArg);
                        break;
                    }
                    case 2: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            if (firstArg.equals("-l")) {
                                consoleRunner = new LocalRunner(args[1]);
                                break;
                            }
                            if (firstArg.equals("-d")) {
                                consoleRunner = new DaemonRunner(args[1]);
                                break;
                            }
                            throw new NullPointerException("Arg " + firstArg + "not recognized");
                        }
                        throw new NullPointerException("Arg " + firstArg + "not recognized");
                    }
                }
            }
            if (consoleRunner != null) {
                TaskRunner.execute(consoleRunner);
                Global.getInstance().setVar(GlobalVar.RUNNER, consoleRunner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

