/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.muplayer.console.ConsoleExecution;
import org.muplayer.console.ConsoleInterpreter;
import org.muplayer.net.Client;
import org.orangelogger.sys.Logger;

public class TCPClient
extends Client {
    private final Socket clientSocket;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public TCPClient(ConsoleInterpreter consoleInterpreter, Socket clientSocket) throws IOException {
        this(consoleInterpreter, clientSocket, clientSocket.getInputStream(), clientSocket.getOutputStream());
    }

    public TCPClient(ConsoleInterpreter consoleInterpreter, Socket clientSocket, InputStream inputStream, OutputStream outputStream) {
        super(consoleInterpreter);
        this.clientSocket = clientSocket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.start();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.inputStream.close();
        this.clientSocket.close();
    }

    @Override
    public void sendString(String str) throws IOException {
        this.outputStream.write(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String recvString() throws IOException {
        StringBuilder sbRead = new StringBuilder();
        while (this.inputStream.available() > 0) {
            int read = this.inputStream.read();
            sbRead.append((char)read);
        }
        return sbRead.toString();
    }

    private String getLoggerHeader() {
        return this.clientSocket.getInetAddress().getHostAddress() + ":" + this.clientSocket.getPort() + " -> ";
    }

    @Override
    public void run() {
        Logger.getLogger((Object)this, (Object)("Client connected from IP " + this.clientSocket.getRemoteSocketAddress().toString()));
        while (true) {
            try {
                while (true) {
                    String command;
                    if ((command = this.recvString()) != null && !command.trim().isEmpty()) {
                        command = command.trim();
                        Logger.getLogger((Object)this, (Object)(this.getLoggerHeader() + "Command received: " + command)).info();
                        ConsoleExecution consoleExecution = this.consoleInterpreter.executeCommand(command.toLowerCase());
                        Logger.getLogger((Object)this, (Object)(this.getLoggerHeader() + "Command executed. ")).info();
                        if (consoleExecution != null && consoleExecution.hasOutput()) {
                            Logger.getLogger((Object)this, (Object)(this.getLoggerHeader() + "Waiting for command processing...")).info();
                            this.sendString(consoleExecution.getOutputMsg().toString());
                            Logger.getLogger((Object)this, (Object)(this.getLoggerHeader() + "Command response sent: " + consoleExecution.getOutputMsg().toString())).info();
                        }
                    }
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                if (!e.getMessage().equalsIgnoreCase("Socket closed")) {
                    e.printStackTrace();
                    continue;
                }
                Logger.getLogger((Object)this, (Object)("Client with IP " + this.clientSocket.getRemoteSocketAddress().toString() + " closed"));
                return;
            }
            break;
        }
    }
}

