/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.muplayer.model.AudioSupport;
import org.muplayer.properties.MessagesInfo;
import org.muplayer.properties.PropertiesFilesInfo;
import org.muplayer.util.DataUtil;
import org.orangelogger.sys.Logger;

public class AudioSupportInfo {
    private final File supportFile;
    private final Properties properties;
    public static final String KEY_PREFFIX = "audio.format.class.";
    private static final AudioSupportInfo singleton = new AudioSupportInfo();

    public static AudioSupportInfo getInstance() {
        return singleton;
    }

    protected AudioSupportInfo() {
        this.supportFile = new File(PropertiesFilesInfo.AUDIO_SUPPORT_FILE_NAME);
        this.properties = new Properties();
        this.loadDefaultData();
    }

    protected AudioSupportInfo(File supportFile) {
        this.supportFile = supportFile;
        this.properties = new Properties();
        this.loadData();
    }

    private void validateFile() throws IOException {
        if (!this.supportFile.exists()) {
            this.supportFile.createNewFile();
        }
    }

    private AudioSupportInfo createTempManager() throws IOException {
        File tempFile = new File(System.currentTimeMillis() + ".properties");
        tempFile.createNewFile();
        String dataFromStream = DataUtil.getDataFromResource("/audio-support.properties");
        Files.write(tempFile.toPath(), dataFromStream.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        return new AudioSupportInfo(tempFile);
    }

    private void loadDefaultData() {
        try {
            if (this.supportFile.exists()) {
                this.loadData();
                AudioSupportInfo tempManager = this.createTempManager();
                Set<String> propertyKeys = tempManager.getPropertyNames();
                propertyKeys.forEach(key -> {
                    String property = this.getProperty((String)key);
                    if (property == null || property.trim().isEmpty()) {
                        this.setProperty((String)key, tempManager.getProperty((String)key));
                    }
                });
                Files.deleteIfExists(tempManager.supportFile.toPath());
            } else {
                String supportData = DataUtil.getDataFromResource("/audio-support.properties");
                this.supportFile.createNewFile();
                Files.write(this.supportFile.toPath(), supportData.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
                this.loadData();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadData() {
        try {
            this.validateFile();
            this.properties.load(new FileInputStream(this.supportFile));
            if (this.properties.isEmpty()) {
                Logger.getLogger((Object)this, (Object)MessagesInfo.getInstance().getProperty("audio.support.file.error")).rawError();
                System.exit(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveData() {
        try {
            this.properties.store(new FileOutputStream(this.supportFile), "Audio formats support");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key.startsWith(KEY_PREFFIX) ? key : KEY_PREFFIX.concat(key));
    }

    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    public Set<String> getAudioExtensions() {
        return this.getPropertyNames().parallelStream().map(prop -> prop.substring(KEY_PREFFIX.length())).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void setProperty(AudioSupport audioSupport) {
        this.setProperty(KEY_PREFFIX.concat(audioSupport.getExtension()), audioSupport.getAudioClass().getName());
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key.startsWith(KEY_PREFFIX) ? key : KEY_PREFFIX.concat(key), value);
        this.saveData();
    }

    public File getSupportFile() {
        return this.supportFile;
    }
}

