/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.console;

import java.util.Arrays;

public class Command {
    private final String order;
    private final String[] options;

    public Command(String order, String ... options) {
        this.order = order;
        this.options = options;
    }

    public Command(String strCmd) {
        String[] cmdSplit = strCmd.split(" ");
        this.order = cmdSplit[0];
        this.options = cmdSplit.length > 1 ? Arrays.copyOfRange(cmdSplit, 1, cmdSplit.length) : null;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public int getOptionsCount() {
        return this.hasOptions() ? this.options.length : 0;
    }

    public String getOptionAt(int index) {
        return this.hasOptions() ? (this.getOptionsCount() > index ? this.options[index] : null) : null;
    }

    public Number getOptionAsNumber(int index) {
        String option = this.getOptionAt(index);
        try {
            return option == null ? null : Double.valueOf(Double.parseDouble(option));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getOrder() {
        return this.order;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getOptionsAsString() {
        if (this.hasOptions()) {
            StringBuilder sbOptions = new StringBuilder();
            for (int i = 0; i < this.options.length; ++i) {
                sbOptions.append(this.options[i]).append(' ');
            }
            sbOptions.deleteCharAt(sbOptions.length() - 1);
            return sbOptions.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder sbCmd = new StringBuilder();
        sbCmd.append(this.order);
        if (this.hasOptions()) {
            for (int i = 0; i < this.options.length; ++i) {
                sbCmd.append(' ').append(this.options[i]);
            }
        }
        return sbCmd.toString();
    }
}

