/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.api.Track;
import net.sourceforge.jaad.spi.javasound.AACAudioFileReader;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.TrackIO;
import org.muplayer.util.AudioUtil;
import org.orangelogger.sys.Logger;

public class M4ATrack
extends Track {
    private boolean isAac;

    public M4ATrack(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource);
    }

    public M4ATrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath);
    }

    public M4ATrack(File dataSource, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public M4ATrack(String trackPath, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    @Override
    protected void loadAudioStream() {
        try {
            this.decodeAAC();
            this.isAac = true;
        }
        catch (UnsupportedAudioFileException e) {
            Logger.getLogger((Object)this, (Object)"File not supported!").rawError();
            e.printStackTrace();
        }
        catch (IOException e) {
            this.trackIO = new TrackIO();
            this.trackIO.setDecodedStream(this.decodeM4A(this.dataSource));
            this.isAac = false;
        }
    }

    private void decodeAAC() throws IOException, UnsupportedAudioFileException {
        this.trackIO = new TrackIO();
        this.trackIO.setAudioReader((AudioFileReader)new AACAudioFileReader());
        this.trackIO.setDecodedStream(AudioUtil.instanceStream(this.trackIO.getAudioReader(), this.dataSource));
    }

    private AudioTrack getM4ATrack(Object source) throws IOException, UnsupportedAudioFileException {
        MP4Container cont = source instanceof RandomAccessFile ? new MP4Container((RandomAccessFile)source) : new MP4Container((InputStream)source);
        Movie movie = cont.getMovie();
        List listContTracks = movie.getTracks((Track.Codec)AudioTrack.AudioCodec.AAC);
        if (listContTracks.isEmpty()) {
            throw new UnsupportedAudioFileException("Movie does not contain any AAC track");
        }
        return (AudioTrack)listContTracks.get(0);
    }

    private AudioInputStream decodeM4A(Object source) {
        try {
            AudioTrack track = source instanceof File ? this.getM4ATrack(new RandomAccessFile((File)source, "r")) : this.getM4ATrack(source);
            Decoder dec = new Decoder(track.getDecoderSpecificInfo());
            SampleBuffer buffer = new SampleBuffer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AudioFormat decFormat = new AudioFormat(track.getSampleRate(), track.getSampleSize(), track.getChannelCount(), true, true);
            while (track.hasMoreFrames()) {
                try {
                    Frame frame = track.readNextFrame();
                    dec.decodeFrame(frame.getData(), buffer);
                    baos.write(buffer.getData());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            byte[] audioData = baos.toByteArray();
            return new AudioInputStream(new ByteArrayInputStream(audioData), decFormat, audioData.length);
        }
        catch (Exception e) {
            Logger.getLogger((Object)this, (String)"Exception", (Object)e).error();
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds.doubleValue();
        return framesToSeek * (double)frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        return bytes.doubleValue() / (double)audioFormat.getFrameSize() / (double)audioFormat.getFrameRate();
    }

    @Override
    public void seek(double seconds) throws IOException {
        if (this.isAac) {
            this.mute();
            super.seek(seconds);
            this.unMute();
        } else {
            super.seek(seconds);
        }
    }

    @Override
    public void gotoSecond(double second) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        double progress = this.getProgress();
        if (second >= progress) {
            int gt = (int)Math.round(second - this.getProgress());
            this.seek(gt);
        } else {
            this.pause();
            if (this.isAac) {
                this.resetStream();
            } else if (this.trackIO.resetDecodedStream()) {
                this.initSpeaker();
            }
            this.resumeTrack();
            this.trackData.setSecsSeeked(0.0);
            this.seek(second);
        }
    }
}

