/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.aucom.sound.Speaker;

public class TrackIO {
    private static final Logger log = Logger.getLogger(TrackIO.class.getName());
    private volatile Speaker speaker;
    private volatile AudioInputStream decodedStream;
    private volatile AudioFileReader audioReader;

    public Speaker createSpeaker() throws LineUnavailableException {
        Speaker speaker = new Speaker(this.decodedStream.getFormat());
        speaker.open();
        return speaker;
    }

    public boolean initSpeaker() throws LineUnavailableException {
        if (this.decodedStream != null) {
            if (this.speaker != null && this.speaker.isOpen()) {
                this.speaker.stop();
                this.speaker.close();
            }
            try {
                this.speaker = this.createSpeaker();
                return true;
            }
            catch (IllegalArgumentException e1) {
                System.err.println("Error: " + e1.getMessage());
                return false;
            }
        }
        log.severe("TrackStream & TrackLine null");
        return false;
    }

    public boolean closeSpeaker() {
        if (this.speaker != null) {
            this.speaker.stop();
            this.speaker.close();
            this.speaker = null;
            return true;
        }
        return false;
    }

    public boolean closeStream() {
        try {
            if (this.decodedStream != null) {
                this.decodedStream.close();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return false;
        }
    }

    public boolean resetDecodedStream() {
        try {
            this.decodedStream.reset();
            return true;
        }
        catch (IOException e) {
            log.severe(e.getMessage());
            return false;
        }
    }

    public double getSecondsPosition() {
        if (this.speaker == null) {
            return 0.0;
        }
        return (double)this.speaker.getDriver().getMicrosecondPosition() / 1000000.0;
    }

    public boolean isTrackStreamsOpened() {
        return this.decodedStream != null && this.speaker != null;
    }

    public AudioFileFormat getAudioFileFormat(Object dataSource) throws IOException, UnsupportedAudioFileException {
        if (this.audioReader != null && dataSource != null) {
            if (dataSource instanceof File) {
                return this.audioReader.getAudioFileFormat((File)dataSource);
            }
            if (dataSource instanceof InputStream) {
                return this.audioReader.getAudioFileFormat((InputStream)dataSource);
            }
            return this.audioReader.getAudioFileFormat((URL)dataSource);
        }
        return null;
    }

    public AudioFormat getAudioFormat() {
        return this.decodedStream.getFormat();
    }

    public float getGain() {
        return this.speaker.getGain();
    }

    public void setGain(float gain) {
        this.speaker.setGain(gain);
    }

    public SourceDataLine getSpeakerDriver() {
        return this.speaker.getDriver();
    }

    public void playAudio(byte[] audioData) {
        this.speaker.playAudio(audioData);
    }

    public Speaker getSpeaker() {
        return this.speaker;
    }

    public AudioInputStream getDecodedStream() {
        return this.decodedStream;
    }

    public AudioFileReader getAudioReader() {
        return this.audioReader;
    }

    public void setSpeaker(Speaker speaker) {
        this.speaker = speaker;
    }

    public void setDecodedStream(AudioInputStream decodedStream) {
        this.decodedStream = decodedStream;
    }

    public void setAudioReader(AudioFileReader audioReader) {
        this.audioReader = audioReader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackIO)) {
            return false;
        }
        TrackIO other = (TrackIO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Speaker this$speaker = this.getSpeaker();
        Speaker other$speaker = other.getSpeaker();
        if (this$speaker == null ? other$speaker != null : !this$speaker.equals(other$speaker)) {
            return false;
        }
        AudioInputStream this$decodedStream = this.getDecodedStream();
        AudioInputStream other$decodedStream = other.getDecodedStream();
        if (this$decodedStream == null ? other$decodedStream != null : !this$decodedStream.equals(other$decodedStream)) {
            return false;
        }
        AudioFileReader this$audioReader = this.getAudioReader();
        AudioFileReader other$audioReader = other.getAudioReader();
        return !(this$audioReader == null ? other$audioReader != null : !this$audioReader.equals(other$audioReader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackIO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Speaker $speaker = this.getSpeaker();
        result = result * 59 + ($speaker == null ? 43 : $speaker.hashCode());
        AudioInputStream $decodedStream = this.getDecodedStream();
        result = result * 59 + ($decodedStream == null ? 43 : $decodedStream.hashCode());
        AudioFileReader $audioReader = this.getAudioReader();
        result = result * 59 + ($audioReader == null ? 43 : $audioReader.hashCode());
        return result;
    }

    public String toString() {
        return "TrackIO(speaker=" + this.getSpeaker() + ", decodedStream=" + this.getDecodedStream() + ", audioReader=" + this.getAudioReader() + ")";
    }

    public TrackIO() {
    }

    public TrackIO(Speaker speaker, AudioInputStream decodedStream, AudioFileReader audioReader) {
        this.speaker = speaker;
        this.decodedStream = decodedStream;
        this.audioReader = audioReader;
    }
}

