/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.muplayer.properties.PropertiesSource;

public abstract class PropertiesInfo<T> {
    protected final PropertiesSource<T> propertiesSource;
    protected final Properties properties;

    protected PropertiesInfo(PropertiesSource<T> propertiesSource) {
        this.propertiesSource = propertiesSource;
        this.properties = new Properties();
        try {
            if (!this.propertiesSource.validate(this.properties)) {
                this.loadDefaultData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract void loadDefaultData();

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Map<Object, Object> getProperties() {
        TreeMap<Object, Object> mapProperties = new TreeMap<Object, Object>();
        mapProperties.putAll(this.properties);
        return mapProperties;
    }

    public void setProperty(String key, String value) throws Exception {
        this.properties.setProperty(key, value);
        this.propertiesSource.saveData(this.properties);
    }

    public PropertiesSource<T> getPropertiesSource() {
        return this.propertiesSource;
    }
}

