/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.properties;

import java.util.Properties;
import java.util.logging.Logger;

public abstract class PropertiesSource<T> {
    private static final Logger log = Logger.getLogger(PropertiesSource.class.getName());
    protected final T source;

    public PropertiesSource(T source) {
        this.source = source;
    }

    public boolean validate(Properties properties) {
        try {
            boolean valid = this.exists();
            if (valid) {
                this.loadData(properties);
            } else {
                this.saveData(properties);
            }
            return valid;
        }
        catch (Exception e) {
            log.severe("Error on PropertiesSource: " + e);
            return false;
        }
    }

    public abstract boolean exists();

    public abstract void loadData(Properties var1) throws Exception;

    public void saveData(Properties properties) throws Exception {
        this.saveData(properties, null);
    }

    public abstract void saveData(Properties var1, String var2) throws Exception;
}

