/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.thread;

import java.io.File;
import org.muplayer.audio.track.Track;
import org.muplayer.system.Time;
import org.orangelogger.sys.Logger;

public class ThreadUtil {
    public static boolean hasOneSecond(long ti) {
        return Time.getInstance().getTime() - ti >= 1000L;
    }

    public static synchronized void freezeThread(Thread thread) {
        try {
            thread.wait();
        }
        catch (InterruptedException e) {
            Logger.getLogger(ThreadUtil.class, (Object)e.getMessage());
        }
    }

    public static synchronized void unfreezeThread(Thread thread) {
        thread.notify();
    }

    public static String generateTrackThreadName(Track track) {
        File dataSource = track.getDataSourceAsFile();
        String trackName = dataSource != null ? dataSource.getName() : dataSource.toString();
        int lengthLimit = Math.min(trackName.length(), 20);
        return "Thread (track=" + trackName.substring(0, lengthLimit) + ")";
    }
}

