/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileReader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.TrackIO;
import org.muplayer.util.AudioUtil;

public class MP3Track
extends Track {
    private final long frameSize;
    private final double frameDurationInSec;

    public MP3Track(File dataSource) throws IOException, UnsupportedAudioFileException, LineUnavailableException, InvalidAudioFrameException {
        this(dataSource, null);
    }

    public MP3Track(File dataSource, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, InvalidAudioFrameException {
        super(dataSource, player);
        MP3AudioHeader audioHeader = new MP3AudioHeader(dataSource);
        long audioStartByte = audioHeader.getMp3StartByte();
        long audioSize = dataSource.length() - audioStartByte;
        long frameCount = audioHeader.getNumberOfFrames();
        this.frameSize = audioSize / frameCount;
        this.frameDurationInSec = audioHeader.getPreciseTrackLength() / (double)frameCount;
    }

    public MP3Track(String trackPath) throws UnsupportedAudioFileException, IOException, LineUnavailableException, InvalidAudioFrameException {
        this(new File(trackPath), null);
    }

    public MP3Track(String trackPath, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException, InvalidAudioFrameException {
        this(new File(trackPath), player);
    }

    @Override
    protected void loadAudioStream() throws IOException, UnsupportedAudioFileException {
        this.trackIO = new TrackIO();
        this.trackIO.setAudioReader((AudioFileReader)new MpegAudioFileReader());
        AudioInputStream encodedAudioStream = AudioUtil.instanceStream(this.trackIO.getAudioReader(), this.dataSource);
        AudioFormat baseFormat = encodedAudioStream.getFormat();
        AudioInputStream trackStream = this.trackIO.getDecodedStream();
        if (trackStream != null) {
            trackStream.close();
        }
        this.trackIO.setDecodedStream(AudioUtil.decodeToPcm(baseFormat, encodedAudioStream));
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        double frameNeeded = seconds.doubleValue() / this.frameDurationInSec;
        return frameNeeded * (double)this.frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        return bytes.doubleValue() / (double)this.frameSize * this.frameDurationInSec;
    }
}

