/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.console.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Scanner;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.player.Player;
import org.muplayer.console.ConsoleExecution;
import org.muplayer.console.ConsoleInterpreter;
import org.orangelogger.sys.Logger;
import org.orangelogger.sys.SystemUtil;

public abstract class ConsoleRunner
implements Runnable {
    protected final Player player;
    protected final ConsoleInterpreter interpreter;
    protected final Scanner scanner;
    protected static final String LINEHEADER = "[MuPlayer]> ";

    public ConsoleRunner() throws FileNotFoundException {
        this((File)null);
    }

    public ConsoleRunner(String folder) throws FileNotFoundException {
        this(new File(folder));
    }

    public ConsoleRunner(File rootFolder) throws FileNotFoundException {
        this(new MusicPlayer(rootFolder));
    }

    public ConsoleRunner(Player player) {
        this.player = player;
        this.interpreter = new ConsoleInterpreter(player);
        this.scanner = new Scanner(System.in);
    }

    protected void printHeader() {
        FileOutputStream stdout = SystemUtil.getStdout();
        try {
            stdout.write(Logger.getLogger((Object)this, (Object)LINEHEADER).getColoredMsg("\u001b[32m").getBytes());
            stdout.flush();
        }
        catch (IOException e) {
            Logger.getLogger((Object)this, (String)e.getClass().getSimpleName(), (Object)e.getMessage()).error();
        }
    }

    public ConsoleExecution execCommand(String strCmd) {
        try {
            return this.interpreter.executeCommand(strCmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Player getPlayer() {
        return this.player;
    }
}

