/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.muplayer.console.runner.DaemonRunner;
import org.muplayer.console.runner.LocalRunner;
import org.muplayer.properties.config.ConfigInfo;
import org.muplayer.properties.log.LogConfig;
import org.muplayer.properties.msg.MessagesInfo;
import org.muplayer.system.Global;
import org.muplayer.system.GlobalVar;
import org.muplayer.thread.TaskRunner;

public class MuPlayer {
    private static final Logger log = Logger.getLogger(MuPlayer.class.getName());

    public static void main(String[] args) {
        try {
            MuPlayer.loadLogConfig();
            Object consoleRunner = null;
            if (args.length == 0) {
                String defaultRootPath = ConfigInfo.getInstance().getProperty("music-folder");
                if (defaultRootPath == null) {
                    throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                }
                consoleRunner = new LocalRunner(defaultRootPath);
            } else {
                switch (args.length) {
                    case 1: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            throw new NullPointerException(MessagesInfo.getInstance().getProperty("musicfolder.property.not.found"));
                        }
                        consoleRunner = new LocalRunner(firstArg);
                        break;
                    }
                    case 2: {
                        String firstArg = args[0].trim();
                        if (firstArg.startsWith("-")) {
                            if (firstArg.equals("-l")) {
                                consoleRunner = new LocalRunner(args[1]);
                                break;
                            }
                            if (firstArg.equals("-d")) {
                                consoleRunner = new DaemonRunner(args[1]);
                                break;
                            }
                            throw new NullPointerException("Arg " + firstArg + "not recognized");
                        }
                        throw new NullPointerException("Arg " + firstArg + "not recognized");
                    }
                }
            }
            if (consoleRunner != null) {
                TaskRunner.execute((Runnable)consoleRunner, consoleRunner.getClass().getSimpleName());
                Global.getInstance().setVar(GlobalVar.RUNNER, consoleRunner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Error on MuPlayer class: " + e);
        }
    }

    private static void loadLogConfig() {
        LogConfig logConfig = LogConfig.getInstance();
        Level logLevel = Level.parse(logConfig.getProperty("logging.level"));
        LogManager logManager = LogManager.getLogManager();
        logManager.getLoggerNames().asIterator().forEachRemaining(logName -> logManager.getLogger((String)logName).setLevel(logLevel));
    }
}

