/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.player;

import java.io.File;
import java.text.DecimalFormat;
import org.muplayer.audio.player.MusicPlayer;
import org.muplayer.audio.track.Track;

public class PlayerInfo {
    private final Track current;
    private final File trackFolder;
    private final File rootFolder;
    private final float volume;
    private final int songsCount;
    private final int foldersCount;

    public PlayerInfo(MusicPlayer musicPlayer) {
        this.current = musicPlayer.getCurrent();
        this.trackFolder = this.current != null && this.current.getDataSourceAsFile() != null ? this.current.getDataSourceAsFile().getParentFile() : null;
        this.rootFolder = musicPlayer.getRootFolder();
        this.volume = musicPlayer.getVolume();
        this.songsCount = musicPlayer.getSongsCount();
        this.foldersCount = musicPlayer.getFoldersCount();
    }

    public String getCurrentTrackTitle() {
        return this.current == null ? "Title Unknown" : this.current.getTitle();
    }

    public String getCurrentTrackFormat() {
        if (this.current == null) {
            return "Track Unknown";
        }
        String currentClass = this.current.getClass().getSimpleName();
        return currentClass.substring(0, currentClass.length() - 5).toLowerCase();
    }

    public String toString() {
        return "{\n\t" + "Track: " + this.getCurrentTrackTitle() + ",\n\t" + "Track Format: " + this.getCurrentTrackFormat() + ",\n\t" + "Track Folder: " + (this.trackFolder == null ? "Unknown" : this.trackFolder.getPath()) + ",\n\t" + "Root Folder: " + (this.rootFolder == null ? "Unknown" : this.rootFolder.getPath()) + ",\n\t" + "Volume: " + new DecimalFormat("#0.0").format(this.volume) + ",\n\t" + "Songs Count: " + this.songsCount + ",\n\t" + "Folder Count: " + this.foldersCount + "\n}";
    }

    public Track getCurrent() {
        return this.current;
    }

    public File getTrackFolder() {
        return this.trackFolder;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public float getVolume() {
        return this.volume;
    }

    public int getSongsCount() {
        return this.songsCount;
    }

    public int getFoldersCount() {
        return this.foldersCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerInfo)) {
            return false;
        }
        PlayerInfo other = (PlayerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (this.getSongsCount() != other.getSongsCount()) {
            return false;
        }
        if (this.getFoldersCount() != other.getFoldersCount()) {
            return false;
        }
        Track this$current = this.getCurrent();
        Track other$current = other.getCurrent();
        if (this$current == null ? other$current != null : !((Object)this$current).equals(other$current)) {
            return false;
        }
        File this$trackFolder = this.getTrackFolder();
        File other$trackFolder = other.getTrackFolder();
        if (this$trackFolder == null ? other$trackFolder != null : !((Object)this$trackFolder).equals(other$trackFolder)) {
            return false;
        }
        File this$rootFolder = this.getRootFolder();
        File other$rootFolder = other.getRootFolder();
        return !(this$rootFolder == null ? other$rootFolder != null : !((Object)this$rootFolder).equals(other$rootFolder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + this.getSongsCount();
        result = result * 59 + this.getFoldersCount();
        Track $current = this.getCurrent();
        result = result * 59 + ($current == null ? 43 : ((Object)$current).hashCode());
        File $trackFolder = this.getTrackFolder();
        result = result * 59 + ($trackFolder == null ? 43 : ((Object)$trackFolder).hashCode());
        File $rootFolder = this.getRootFolder();
        result = result * 59 + ($rootFolder == null ? 43 : ((Object)$rootFolder).hashCode());
        return result;
    }
}

