/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.thread;

import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.muplayer.thread.TracksLoader;

public class TracksLoaderCleaner
extends Thread {
    private static final Logger log = Logger.getLogger(TracksLoaderCleaner.class.getName());
    private final TracksLoader tracksLoader = TracksLoader.getInstance();
    private final CompletableFuture<?> task;

    public TracksLoaderCleaner(CompletableFuture<?> task) {
        this.task = task;
        this.setName(this.getClass().getSimpleName() + " [task=" + task.hashCode() + "]");
    }

    @Override
    public void run() {
        while (!this.task.isDone()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.tracksLoader.removeTask(this.task);
    }
}

