/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.audio.track;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.jflac.sound.spi.FlacAudioFileReader;
import org.jflac.sound.spi.FlacFormatConversionProvider;
import org.muplayer.audio.player.Player;
import org.muplayer.audio.track.Track;
import org.muplayer.audio.track.TrackIO;
import org.muplayer.util.AudioUtil;

public class FlacTrack
extends Track {
    public FlacTrack(File dataSource) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource);
    }

    public FlacTrack(String trackPath) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath);
    }

    public FlacTrack(File dataSource, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(dataSource, player);
    }

    public FlacTrack(String trackPath, Player player) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        super(trackPath, player);
    }

    @Override
    protected void loadAudioStream() {
        try {
            this.trackIO = new TrackIO();
            this.trackIO.setAudioReader((AudioFileReader)new FlacAudioFileReader());
            AudioInputStream flacEncodedStream = AudioUtil.instanceStream(this.trackIO.getAudioReader(), this.dataSource);
            AudioFormat format = flacEncodedStream.getFormat();
            AudioFormat decodedFormat = AudioUtil.getPcmFormatByFlac(format);
            this.trackIO.setDecodedStream(new FlacFormatConversionProvider().getAudioInputStream(decodedFormat, flacEncodedStream));
        }
        catch (IOException | UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected double convertSecondsToBytes(Number seconds) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        float frameRate = audioFormat.getFrameRate();
        int frameSize = audioFormat.getFrameSize();
        double framesToSeek = (double)frameRate * seconds.doubleValue();
        return framesToSeek * (double)frameSize;
    }

    @Override
    protected double convertBytesToSeconds(Number bytes) {
        AudioFormat audioFormat = this.trackIO.getAudioFormat();
        return bytes.doubleValue() / (double)audioFormat.getFrameSize() / (double)audioFormat.getFrameRate();
    }

    @Override
    public synchronized void seek(double seconds) throws IOException {
        if (seconds == 0.0) {
            return;
        }
        this.trackData.setSecsSeeked(this.trackData.getSecsSeeked() + seconds);
        int bytesToSeek = (int)Math.round(this.convertSecondsToBytes(seconds));
        AudioInputStream decodedStream = this.trackIO.getDecodedStream();
        if (decodedStream != null) {
            decodedStream.read(new byte[bytesToSeek]);
        }
    }
}

