/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.interfaces;

import org.muplayer.audio.info.AudioHardware;
import org.muplayer.system.Time;

public interface ControllableMusic {
    public boolean isPlaying() throws Exception;

    public boolean isPaused() throws Exception;

    public boolean isStopped() throws Exception;

    public boolean isMute();

    public void play() throws Exception;

    public void pause() throws Exception;

    public void resumeTrack() throws Exception;

    public void stopTrack() throws Exception;

    public void reload() throws Exception;

    public void seek(double var1) throws Exception;

    public void gotoSecond(double var1) throws Exception;

    public float getVolume();

    public void setVolume(float var1);

    default public float getSystemVolume() {
        return AudioHardware.getFormattedSpeakerVolume();
    }

    default public void setSystemVolume(float volume) {
        AudioHardware.setFormattedSpeakerVolume(volume);
    }

    public void mute();

    public void unMute();

    public double getProgress();

    default public String getFormattedProgress() {
        return Time.getInstance().getTimeFormatter().format((long)this.getProgress());
    }

    public long getDuration();

    default public String getFormattedDuration() {
        return Time.getInstance().getTimeFormatter().format(this.getDuration());
    }
}

