/*
 * Decompiled with CFR 0.152.
 */
package org.muplayer.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.bytebuffer.ByteBuffer;
import org.muplayer.util.DataUtil;

public class IOUtil {
    public static boolean isEqualsBuffers(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        int read;
        ByteBuffer byteBuffer = new ByteBuffer();
        while ((read = inputStream.read()) != -1) {
            byteBuffer.add(read);
        }
        return byteBuffer.toArray();
    }

    public static String getAsciiStringFromStream(InputStream inputStream) throws IOException {
        byte[] buffer = IOUtil.getBytesFromStream(inputStream);
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public static byte[] getBytesFromPath(String path) throws IOException {
        return Files.readAllBytes(new File(path).toPath());
    }

    public static byte[] getBytesFromRes(String path) throws IOException {
        return IOUtil.getBytesFromStream(DataUtil.getResourceAsStream(path));
    }

    public static InputStream getInputStream(File file) throws IOException {
        return Files.newInputStream(file.toPath(), StandardOpenOption.READ);
    }

    public static BufferedReader getBufferedReader(File file) throws IOException {
        return Files.newBufferedReader(file.toPath(), Charset.defaultCharset());
    }

    public static InputStream getArrayStreamFromRes(String path) throws IOException {
        return new ByteArrayInputStream(IOUtil.getBytesFromRes(path));
    }
}

