/*
 * Decompiled with CFR 0.152.
 */
package org.orangeplayer.client.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.bytebuffer.ByteBuffer;

public class ServerConnection {
    private final String host;
    private final int port;

    public ServerConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    private BufferedReader getReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in));
    }

    public URL getUrl(String path) throws MalformedURLException {
        return new URL("http", this.host, this.port, path);
    }

    public URLConnection openUrlConnection(String path) throws IOException {
        return this.getUrl(path).openConnection();
    }

    public InputStream openUrlStream(String path) throws IOException {
        return this.getUrl(path).openStream();
    }

    public byte[] getUrlData(String path) throws IOException {
        int read;
        InputStream inputStream = this.openUrlStream(path);
        ByteBuffer byteBuffer = new ByteBuffer(10240);
        byte[] buffer = new byte[1024];
        while ((read = inputStream.read(buffer)) != -1) {
            byteBuffer.addFrom(buffer, 0, read);
        }
        return byteBuffer.drain();
    }

    public String getUrlContent(String path) throws IOException {
        StringBuilder sbContent = new StringBuilder();
        this.getReader(this.openUrlStream(path)).lines().forEach(sbContent::append);
        return sbContent.toString();
    }
}

