# bootstrap
Clojure Bootstrap Utilities

## Status
[![Build Status](https://travis-ci.org/CraZySacX/bootstrap.png)](https://travis-ci.org/CraZySacX/bootstrap)
[![Dependencies Status](http://jarkeeper.com/CraZySacX/bootstrap/status.png)](http://jarkeeper.com/CraZySacX/bootstrap)
 
### bootstrap
Bootstrap a jar via ssh at the given host.  Note, a working password-less ssh connection should be setup for this to work.

The keword arguments:

* user - The username to ssh as.
* host - The host to ssh at.
* path - The path on the host to bootstrap at.  Note the user above should have the appropriate permissions to write to this path.
* jar - The path to the local jar file you wish to bootstrap remotely.
* options - The options to pass to the jar command.

The host, path and jar arguments are required.  The user and options arguments are optional.

#### Examples
*Bootstrap a standalone uberjar*

```clojure
(ns booter
  (:require [clojure.java.io :as io]
            [org.ozias.cljlibs.bootstrap.bootstrap :as boot]))

(boot/bootstrap :user "jozias" :host "host" :path "/path/at/host" 
                :jar (io/file "/path/to/local/jarfile.jar"))
```
