(ns org.ozias.cljlibs.bootstrap.wgetjava
  (:require [org.ozias.cljlibs.shell.shell :refer :all]
            [taoensso.timbre :refer (info)]))

(def ^:private wget ["wget" "-c" "--no-cookies" "--no-check-certificate" "-P" "/tmp"])

(def ^:private urlmap
  {:jdk {:7 {:51 {:baseurl "http://download.oracle.com/otn-pub/java/jdk/7u51-b13/"
                  :lin {:32 {:rpm "jdk-7u51-linux-i586.rpm"
                             :tgz "jdk-7u51-linux-i586.tar.gz"}
                        :64 {:rpm "jdk-7u51-linux-x64.rpm"
                             :tgz "jdk-7u51-linux-x64.tar.gz"}}
                  :mac {:64 {:dmg "jdk-7u51-macosx-x64.dmg"}}
                  :win {:32 {:exe "jdk-7u51-windows-i586.exe"}
                        :64 {:exe "jdk-7u51-windows-x64.exe"}}}}
         :8 {:b124 {:baseurl "http://www.java.net/download/jdk8/archive/b124/binaries/"
                    :lin {:32 {:tgz "jdk-8-ea-bin-b124-linux-i586-19_jan_2014.tar.gz"}
                          :64 {:tgz "jdk-8-ea-bin-b124-linux-x64-19_jan_2014.tar.gz"}}
                    :mac {:64 {:dmg "jdk-8-ea-bin-b124-macosx-x86_64-19_jan_2014.dmg"}}
                    :win {:32 {:exe "jdk-8-ea-bin-b124-windows-i586-17_jan_2014.exe"}
                          :64 {:exe "jdk-8-ea-bin-b124-windows-x64-17_jan_2014.exe"}}}}}
   :jre {:7 {:51 {:baseurl "http://download.oracle.com/otn-pub/java/jdk/7u51-b13/"
                  :lin {:32 {:rpm "jre-7u51-linux-i586.rpm"
                             :tgz "jre-7u51-linux-i586.tar.gz"}
                        :64 {:rpm "jre-7u51-linux-x64.rpm"
                             :tgz "jre-7u51-linux-x64.tar.gz"}}
                  :mac {:64 {:dmg "jre-7u51-macosx-x64.dmg"
                             :tgz "jre-7u51-macosx-x64.tar.gz"}}
                  :win {:32 {:onl "jre-7u51-windows-i586-iftw.exe"
                             :exe "jre-7u51-windows-i586.exe"
                             :tgz "jre-7u51-windows-i586.tar.gz"}
                        :64 {:exe "jre-7u51-windows-x64.exe"
                             :tgz "jre-7u51-windows-x64.tar.gz"}}}}
         :8 {:b124 {:baseurl "http://www.java.net/download/jdk8/archive/b124/binaries/"
                    :lin {:32 {:tgz "jre-8-ea-bin-b124-linux-i586-19_jan_2014.tar.gz"}
                          :64 {:tgz "jre-8-ea-bin-b124-linux-x64-19_jan_2014.tar.gz"}}
                    :mac {:64 {:dmg "jre-8-ea-bin-b124-macosx-x86_64-19_jan_2014.dmg"}}
                    :win {:32 {:exe "jre-8-ea-bin-b124-windows-i586-17_jan_2014.exe"}
                          :64 {:exe "jre-8-ea-bin-b124-windows-x64-17_jan_2014.exe"}}}}}})

(defn- flatten-map
  ([m sep]
     (into {} (flatten-map m sep nil)))
  ([m sep pre]
     (mapcat (fn [[k v]]
               (let [prefix (if pre (str pre sep (name k)) (name k))]
                 (if (map? v)
                   (flatten-map v sep prefix)
                   [[(keyword prefix) v]])))
             m)))

(defn valid-keys []
  (->> (flatten-map urlmap "-")
       (keys)
       (map #(clojure.string/split (name %) #"-"))
       (filter (fn [v] (not-any? #(= "baseurl" %) v)))
       (into [])
       (sort-by (juxt first second #(nth % 3) #(nth % 4) #(nth % 5)))
       (map reverse)
       (map #(zipmap [:filetype :arch :os :pr :ver :type] %))))

(defn download [&{:keys [type ver pr os arch filetype]
                  :or {type :jdk ver :7 pr :51 os :lin arch :64 filetype :tgz}}]
  (let [baseurl (-> urlmap type ver pr :baseurl)
        wget (if (= ver :8) 
               (-> wget (conj "--post-data" "LicResponses[1].checked&form1=submit"))
               (-> wget (conj "--header" "Cookie: gpw_e24=http%3A%2F%2Fwww.oracle.com%2F")))]
    (when-let [file (-> urlmap type ver pr os arch filetype)]
      (-> wget (conj (str baseurl file)) shell-cmd successful?)
      file)))
