(ns org.ozias.cljlibs.mvnmeta.mvnmeta
  (:require [clojure.string :as str :only (join replace)]))

(defn- protocol-dispatch-fn [{:keys [url]}]
  (if (seq url)
    (->> url 
         (take-while #(not (= \: %)))
         (apply str))))

(defmulti artifact-metadata
  "Dispatch on protocol string given a map with a :url key"
  protocol-dispatch-fn)

(defmethod artifact-metadata :default [protocol]
  (let [protocolstr (protocol-dispatch-fn protocol)]
    (throw (Exception. (str "Unknown protocol" (if-not protocolstr "" (str ": " protocolstr)))))))

(defn- gen-url [{:keys [url group-id artifact-id filename]}]
  (->> [(if (= (last url) \/) (butlast url) url)
        (if group-id (str/replace group-id "." "/") artifact-id)
        artifact-id
        (or filename "maven-metadata.xml")]
       (str/join "/")))

(defn- parse-xml [kw]
  (fn [xmlseq]
    (->> (for [element xmlseq]
           (if (= (:tag element) kw)
             (first (:content element))))
         (remove nil?)
         (into []))))

(defn fetch-artifact-metadata [fetchfn repomap]
  (let [metadata (fetchfn (assoc repomap :url (gen-url repomap)))
        get-versions (parse-xml :version)
        get-release (parse-xml :release)
        get-latest (parse-xml :latest)
        get-last-updated (parse-xml :lastUpdated)]
    (assoc {} 
      :versions (get-versions metadata)
      :release (get-release metadata)
      :latest (get-latest metadata)
      :lastUpdated (get-last-updated metadata))))
