(ns org.ozias.cljlibs.mvnmeta.protocol.httpx
  (:require [clj-http.client :as client :only (get)]
            [clojure.data.xml :as xml :only (parse-str)]
            [org.ozias.cljlibs.mvnmeta.mvnmeta :refer :all]))

(defn- checkauth [username password passphrase type]
  (if (and username (or password passphrase))
    (if (or (nil? type) (= type :basic))
      {:basic-auth [username (or password passphrase)]}
      {:digest-auth [username (or password passphrase)]})))

(defn- fetch-metadata [{:keys [url username password passphrase type]}]
  (let [getargs (conj [] url)
        getargs (if-let [auth (checkauth username password passphrase type)]
                  (conj getargs auth)
                  getargs)]
    (-> (apply client/get getargs)
        :body
        xml/parse-str
        xml-seq)))

(defmethod artifact-metadata "http" [repomap]
  (fetch-artifact-metadata fetch-metadata repomap))

(defmethod artifact-metadata "https" [repomap]
  (fetch-artifact-metadata fetch-metadata repomap))
