(ns org.ozias.cljlibs.mvnmeta.protocol.file
  (:require [clojure.data.xml :as xml :only (parse-str)]
            [org.ozias.cljlibs.mvnmeta.mvnmeta :refer :all]))

(defn- fetch-md [{:keys [url]}]
  (try
    (-> url slurp xml/parse-str xml-seq)
    (catch java.io.FileNotFoundException fnfe fnfe)
    (catch Exception e e)))

(def fetch-metadata (memoize fetch-md))

(defmethod artifact-metadata "file" [mvnmetamap]
  (fetch-artifact-metadata fetch-metadata mvnmetamap))
