(ns org.ozias.cljlibs.scm.cvs
  (:require [clojure.string :refer [split trim]]
            [me.raynes.conch :refer [with-programs]]
            [org.ozias.cljlibs.scm.core :refer :all]))

(def ^{:doc "A vector of all supported git commands"}
  cvs-cmdv
  ["add" "admin" "annotate" "checkout" "commit" "diff" "edit" "editors"
   "export" "history" "import" "init" "log" "login" "logout" "pserver"
   "rannotate" "rdiff" "release" "remove" "rlog" "rtag" "server" "status"
   "tag" "unedit" "update" "version" "watch" "watchers"])

(gen-scm-test-fn "cvs")

(defn cvs-help-parse
  "parse the cvs help output for a list of supported commands"
  []
  (if (cvs?)
    (->> (with-programs [cvs] (cvs "--help-commands" {:seq :err}))
         (butlast)
         (rest)
         (map trim)
         (map #(split % #"  +"))
         (map first)
         (sort))))

(gen-base-scm-fn "cvs")
(defmacro gen-cvs-fns
  "Generate the cvs functions"
  []
  (gen-scm-fns "cvs" cvs-cmdv))
(gen-cvs-fns)
