(ns org.ozias.cljlibs.scm.hg
  (:require [clojure.string :refer [split trim]]
            [me.raynes.conch :refer [with-programs]]
            [org.ozias.cljlibs.scm.core :refer :all]))

(def ^{:doc "A vector of all supported hg commands"}
  hg-cmdv
  ["add" "addremove" "annotate" "archive" "backout" "bisect" "bookmarks"
   "branch" "branches" "bundle" "cat" "clone" "commit" "copy" "diff"
   "export" "forget" "graft" "grep" "heads" "help" "identify" "import"
   "incoming" "init" "locate" "log" "manifest" "merge" "outgoing" "parents"
   "paths" "phase" "pull" "push" "recover" "remove" "rename" "resolve"
   "revert" "root" "serve" "showconfig" "status" "summary" "tag" "tags"
   "unbundle" "update" "verify" "version"])

(gen-scm-test-fn "hg")

(defn hg-help-parse
  "parse the hg help output for a list of supported commands"
  []
  (if (hg?)
    (->> (nth (->> (with-programs [hg] (hg "help" {:seq true}))
                   (partition-by #(= "" %))
                   (filter #(not= (list "") %))) 2)
         (map trim)
         (map #(split % #"  +"))
         (map first)
         (into [])
         (sort))))

(gen-base-scm-fn "hg")
(defmacro gen-hg-fns
  "Generate the hg functions"
  []
  (gen-scm-fns "hg" hg-cmdv))
(gen-hg-fns)
