(ns org.ozias.cljlibs.shell.shell
  (:require [me.raynes.conch :refer (let-programs)]
            [org.ozias.cljlibs.utils.core 
             :refer (assoc-if localhost? successful?)]))

(defn cmd->sshcmd
  "Given a target, evaluates to a function that takes a command vector
  as an argument.

  If the target is not a localhost target, [\"ssh\" target] will be
  prepended to the command vector."
  [target]
  (if (localhost? target)
    (fn [cmd] cmd)
    (fn [cmd] (into ["ssh" target] cmd))))

(defn shell-cmd
  "Execute the given shell command.

  cmdv should be a vector of strings representing
  the command you wish to execute.
  [\"ls\" \"-al\"]

  If basedir is supplied, the command will be run in that directory."
  [cmdv & {:keys [basedir out err buffer]}]
  (if (and (seq cmdv)(vector? cmdv)(every? string? cmdv))
    (let [process-map (assoc-if {:seq true :verbose true}
                                :basedir basedir :out out
                                :err err :buffer buffer)]
      (let-programs [cmd (first cmdv)]
                    (apply cmd (conj (subvec cmdv 1) process-map))))))
