# shell
Clojure Shell Utilities

I found myself using the [Conch](https://github.com/Raynes/conch "Conch") library with 
a similar pattern every time I called it, so I've written a wrapper function to encapsulate
those similarities.
 
### shell-cmd
Execute a shell command.

Called with a command vector ```["ls" "-al"]``` and an optional argument ```:basedir``` 
that represents the directory you wish to run the command in.  If no ```:basedir``` is 
supplied the command will be run in the current directory from which your program is executing.

#### Examples
*List all files in your /tmp directory*

```clojure
(org.ozias.cljlibs.shell/shell-cmd ["ls" "-al"] :basedir "/tmp")
```

*List all files in your current directory*

```clojure
(org.ozias.cljlibs.shell/shell-cmd ["ls" "-al"])
```

The function will evaluate to a map of the following format:

```clojure
{:proc {:out (...), :in ..., :err ..., :process ..., 
        :exit-code ..., :stdout ..., :stderr ...}}
```

In general, you are most interested in ```:out``` and ```:exit-code```.  Note that ```:out``` 
will be a sequence, and ```:exit-code``` must be dereferenced to access the value.

### cmd->sshcmd
Translate the given command into a command executed via ssh.

If the target is localhost, or user@localhost, the command will be executed locally.

#### Examples
*List all files in the /tmp directory for user@host*

```clojure
(require '[org.ozias.cljlibs.shell.shell :as sh])

(let [ssh (sh/cmd->sshcmd "user@host")]
  (-> ["ls" "-al"] ssh sh/shell-cmd))
```

### Notes
This library uses the [timbre](https://github.com/ptaoussanis/timbre "timbre") logging library.
If you wish to suppress the debug output of the command (debug to standard out is on by default), 
use the following:

```clojure
(taoensso.timbre/set-level! :info)
```