(ns org.ozias.cljlibs.shell.shell
  (:require [me.raynes.conch :refer (let-programs)]
            [taoensso.timbre :refer (debug)]))

(defn shell-cmd 
  "Execute the given shell command.

  cmdv should be a vector of strings representing the command you wish to execute.
  [\"ls\" \"-al\"]

  If basedir is supplied, the command will be run in that directory."
  [cmdv & {:keys [basedir]}]
  (let [out (fn [line _] (debug line))
        process-map {:out out :err out :seq true :verbose true}
        process-map (if (seq basedir) (assoc process-map :dir basedir) process-map)]
    (let-programs [cmd (first cmdv)]
                  (apply cmd (conj (subvec cmdv 1) process-map)))))
