(ns org.ozias.cljlibs.shell.shell
  (:require [me.raynes.conch :refer (let-programs)]
            [taoensso.timbre :refer (debug)]))

(defn- out [line _]
  (debug line))

(defn shell-cmd [cmdv & {:keys [basedir]}]
  (let [process-map {:out out :err out :seq true :verbose true}
        process-map (if (seq basedir) (assoc process-map :dir basedir) process-map)]
    (debug process-map)
    (debug cmdv)
    (let-programs [cmd (first cmdv)]
                  (apply cmd (conj (subvec cmdv 1) process-map)))))
