(ns org.ozias.cljlibs.utils.core
  (:require [clojure.string :refer (trim trim-newline)]
            [environ.core :refer :all]
            [me.raynes.conch :refer (with-programs)]))

(defn linux? []
  (.startsWith (env :os-name) "Linux"))

(defn mac? []
  (.startsWith (env :os-name) "Mac"))

(defn windows? []
  (.startsWith (env :os-name) "Windows"))

(defn- nix-arch []
  (with-programs [uname]
    (let [arch (trim-newline (uname "-m"))]
      (if (= "x86_64" arch)
        64
        (if (= "i686" arch)
          32)))))

(defn- os-key-dispatcher []
  (cond
   (linux?) :linux
   (mac?) :mac
   (windows?) :windows))

(defmulti processor-arch os-key-dispatcher)
    
(defmethod processor-arch :windows []
  (let [arch (env :processor-architecture)]
    (if (= "AMD64" arch)
      64
      (if (= "x86" arch)
        32))))

(defmethod processor-arch :linux []
  (nix-arch))

(defmethod processor-arch :max []
  (nix-arch))

(defn bits-64? []
  (= 64 (processor-arch)))

(defn bits-32? []
  (= 32 (processor-arch)))

(defn cores []
  (with-programs [nproc]
    (-> (nproc) trim Integer/parseInt (- 1) (max 1))))
