(ns lein-git-version.plugin
  (:require [leiningen.jar :as jar]
            [leiningen.git-version :refer [gen-version]]
            [robert.hooke :refer (add-hook)]))
                   
(def defaults
  {:version-command []
   :project-format ["%s" :basever]
   :version-file-command []
   :file-format ["%s" :basever]
   :assoc-in-keys [[:version]]
   :filepath nil
   :filename "version.clj"})

(defn- retain-whitelisted-keys [f & [new original]]
  (merge new (select-keys original (into jar/whitelist-keys [:version :manifest]))))

(defn hooks[]
  (add-hook #'leiningen.jar/retain-whitelisted-keys #'retain-whitelisted-keys))

(defn middleware [{:keys [git-version] :as project}]
  (let [config (merge defaults git-version)
        project (assoc project :git-version config)
        version (gen-version project)]
    (reduce #(assoc-in %1 %2 version) project (:assoc-in-keys config))))
