(defproject org.ozias.plugins/lein-git-version "1.1.0-SNAPSHOT"
  :description "Use git for project versions"
  :url "https://github.com/CraZySacX/lein-git-version"
  :license {:name "MIT"
            :url "http://opensource.org/licenses/MIT"}
  :profiles {:dev {:dependencies [[clj-time "0.6.0"]
                                  [colorize "0.1.1"]
                                  [midje "1.6.0"]
                                  [org.clojure/clojure "1.5.1"]]
                   :plugins [[lein-midje "3.1.3"]]}}
  :middleware [lein-git-version.plugin/middleware]
  :aliases {"package" ["do" "clean," "install"]
            "dep" ["do" "deploy," "deploy" "clojars"]
            "all" ["do" "package," "dep"]}
  :jvm-opts ["-Xms1024m" "-Xmx1024m"]
  :deploy-repositories [["snapshots" 
                         {:url "http://www.ozias.net/artifactory/libs-snapshot-local"
                          :creds :gpg}]
                        ["releases"
                         {:url "http://www.ozias.net/artifactory/libs-release-local"
                          :creds :gpg}]]
  :test-paths ["test" "testsrc"]
  :scm {:name "git"
        :url "https://github.com/CraZySacX/lein-git-version"}
  :manifest {"Implementation-Version" "1.1.0-SNAPSHOT"}
  :git-version {:file {:filepath "lein_git_version"}
                :manifest {:cmd ["git" "rev-parse" "HEAD"]
                           :fmt ["%s+%s.%s" :basever :cmdver :date]
                           :assoc-in-keys [[:manifest "Implementation-Version"]]}}
  :eval-in-leiningen true)
