(ns lein-git-version.plugin
  (:require [leiningen.jar :as jar]
            [leiningen.git-version :refer :all]
            [robert.hooke :refer (add-hook)]))

(defn- retain-whitelisted-keys [f & [new original]]
  (merge new (select-keys original (into jar/whitelist-keys [:version :manifest]))))

(defn hooks[]
  (add-hook #'leiningen.jar/retain-whitelisted-keys #'retain-whitelisted-keys))

(defn middleware [project]
  (->> project regen-project version-assocs))
