// Compiled by ClojureScript 1.10.520 {}
goog.provide('org.parkerici.blockoid.core');
goog.require('cljs.core');
goog.require('blockly');
goog.require('cljs.nodejs');
goog.require('re_frame.core');
goog.require('clojure.data.xml');
org.parkerici.blockoid.core.blockly = cljs.nodejs.require.call(null,"blockly");
org.parkerici.blockoid.core.workspace = cljs.core.atom.call(null,null);
org.parkerici.blockoid.core.blockly_div = cljs.core.atom.call(null,null);
org.parkerici.blockoid.core.callback_keys = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Initialize Blockly. Args:
 *   div:  Name of the HTML div element in which to inject Blockly
 *  toolbox-xml: XML in EDN format. Usually generated by `toolbox`. 
 *  options: map of additional options to `inject`, eg: `{:zoom true}`. See https://developers.google.com/blockly/guides/get-started/web#configuration
 * 
 *  change-handler: a fn of one argument (event) that gets called on any changes to the workspace. 
 */
org.parkerici.blockoid.core.define_workspace = (function org$parkerici$blockoid$core$define_workspace(div,toolbox_xml,options,change_handler){
cljs.core.reset_BANG_.call(null,org.parkerici.blockoid.core.workspace,Blockly.inject(div,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"toolbox","toolbox",762819836),clojure.data.xml.emit_str.call(null,toolbox_xml)], null),options))));

cljs.core.reset_BANG_.call(null,org.parkerici.blockoid.core.blockly_div,div);

var seq__2555_2571 = cljs.core.seq.call(null,cljs.core.deref.call(null,org.parkerici.blockoid.core.callback_keys));
var chunk__2556_2572 = null;
var count__2557_2573 = (0);
var i__2558_2574 = (0);
while(true){
if((i__2558_2574 < count__2557_2573)){
var vec__2565_2575 = cljs.core._nth.call(null,chunk__2556_2572,i__2558_2574);
var ckey_2576 = cljs.core.nth.call(null,vec__2565_2575,(0),null);
var handler_2577 = cljs.core.nth.call(null,vec__2565_2575,(1),null);
cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).registerButtonCallback(ckey_2576,handler_2577);


var G__2578 = seq__2555_2571;
var G__2579 = chunk__2556_2572;
var G__2580 = count__2557_2573;
var G__2581 = (i__2558_2574 + (1));
seq__2555_2571 = G__2578;
chunk__2556_2572 = G__2579;
count__2557_2573 = G__2580;
i__2558_2574 = G__2581;
continue;
} else {
var temp__5735__auto___2582 = cljs.core.seq.call(null,seq__2555_2571);
if(temp__5735__auto___2582){
var seq__2555_2583__$1 = temp__5735__auto___2582;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__2555_2583__$1)){
var c__4550__auto___2584 = cljs.core.chunk_first.call(null,seq__2555_2583__$1);
var G__2585 = cljs.core.chunk_rest.call(null,seq__2555_2583__$1);
var G__2586 = c__4550__auto___2584;
var G__2587 = cljs.core.count.call(null,c__4550__auto___2584);
var G__2588 = (0);
seq__2555_2571 = G__2585;
chunk__2556_2572 = G__2586;
count__2557_2573 = G__2587;
i__2558_2574 = G__2588;
continue;
} else {
var vec__2568_2589 = cljs.core.first.call(null,seq__2555_2583__$1);
var ckey_2590 = cljs.core.nth.call(null,vec__2568_2589,(0),null);
var handler_2591 = cljs.core.nth.call(null,vec__2568_2589,(1),null);
cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).registerButtonCallback(ckey_2590,handler_2591);


var G__2592 = cljs.core.next.call(null,seq__2555_2583__$1);
var G__2593 = null;
var G__2594 = (0);
var G__2595 = (0);
seq__2555_2571 = G__2592;
chunk__2556_2572 = G__2593;
count__2557_2573 = G__2594;
i__2558_2574 = G__2595;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).addChangeListener(change_handler);
});
/**
 * Update the toolbox, keeping workspace the same (warning: dangerous)
 */
org.parkerici.blockoid.core.update_toolbox = (function org$parkerici$blockoid$core$update_toolbox(toolbox_def){
return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).updateToolbox(clojure.data.xml.emit_str.call(null,toolbox_def));
});
org.parkerici.blockoid.core.area_div = cljs.core.atom.call(null,null);
/**
 * Compute the absolute coordinates and dimensions of blocklyArea
 */
org.parkerici.blockoid.core.on_resize = (function org$parkerici$blockoid$core$on_resize(_){
var blockly_area = document.getElementById(cljs.core.deref.call(null,org.parkerici.blockoid.core.area_div));
var blockly_div = document.getElementById(cljs.core.deref.call(null,org.parkerici.blockoid.core.blockly_div));
var element = blockly_area;
var x = (0);
var y = (0);
while(true){
if(cljs.core.truth_(element)){
var G__2596 = element.offsetParent;
var G__2597 = (x + element.offsetLeft);
var G__2598 = (y + element.offsetTop);
element = G__2596;
x = G__2597;
y = G__2598;
continue;
} else {
blockly_div.style.left = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"px"].join('');

blockly_div.style.top = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(y),"px"].join('');

blockly_div.style.width = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(blockly_area.offsetWidth),"px"].join('');

blockly_div.style.height = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(blockly_area.offsetHeight),"px"].join('');

return Blockly.svgResize(cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace));
}
break;
}
});
/**
 * Call this after `define-workspace` to enable automatic resizing
 */
org.parkerici.blockoid.core.auto_resize_workspace = (function org$parkerici$blockoid$core$auto_resize_workspace(div){
cljs.core.reset_BANG_.call(null,org.parkerici.blockoid.core.area_div,div);

window.addEventListener("resize",org.parkerici.blockoid.core.on_resize,false);

return org.parkerici.blockoid.core.on_resize.call(null,null);
});
/**
 * Returns the block js object
 */
org.parkerici.blockoid.core.get_block = (function org$parkerici$blockoid$core$get_block(block_id){
return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).getBlockById(block_id);
});
/**
 * Get the value of a block field
 */
org.parkerici.blockoid.core.get_block_field_value = (function org$parkerici$blockoid$core$get_block_field_value(block_id,field_name){
return org.parkerici.blockoid.core.get_block.call(null,block_id).getFieldValue(field_name);
});
/**
 * Set the value of a block field
 */
org.parkerici.blockoid.core.set_block_field_value = (function org$parkerici$blockoid$core$set_block_field_value(block_id,field_name,value){
return org.parkerici.blockoid.core.get_block.call(null,block_id).setFieldValue(value,field_name);
});
org.parkerici.blockoid.core.block_xml_string = (function org$parkerici$blockoid$core$block_xml_string(block){
return Blockly.Xml.domToText(Blockly.Xml.blockToDom(block));
});
org.parkerici.blockoid.core.block_xml = (function org$parkerici$blockoid$core$block_xml(block){
return clojure.data.xml.parse_str.call(null,org.parkerici.blockoid.core.block_xml_string.call(null,block));
});
org.parkerici.blockoid.core.workspace_xml_string = (function org$parkerici$blockoid$core$workspace_xml_string(){
return Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace)));
});
org.parkerici.blockoid.core.workspace_xml = (function org$parkerici$blockoid$core$workspace_xml(){
return clojure.data.xml.parse_str.call(null,org.parkerici.blockoid.core.workspace_xml_string.call(null));
});
org.parkerici.blockoid.core.clear_workspace = (function org$parkerici$blockoid$core$clear_workspace(){
return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).clear();
});
org.parkerici.blockoid.core.encode_xml = (function org$parkerici$blockoid$core$encode_xml(xml){
var xml_string = clojure.data.xml.emit_str.call(null,xml);
return Blockly.Xml.textToDom(xml_string);
});
org.parkerici.blockoid.core.set_workspace_xml = (function org$parkerici$blockoid$core$set_workspace_xml(xml){
var dom = org.parkerici.blockoid.core.encode_xml.call(null,xml);
org.parkerici.blockoid.core.clear_workspace.call(null);

return Blockly.Xml.domToWorkspace(dom,cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace));
});
org.parkerici.blockoid.core.add_workspace_xml = (function org$parkerici$blockoid$core$add_workspace_xml(xml){
var dom = org.parkerici.blockoid.core.encode_xml.call(null,xml);
return Blockly.Xml.appendDomToWorkspace(dom,cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace));
});
org.parkerici.blockoid.core.selected_block = (function org$parkerici$blockoid$core$selected_block(){
return Blockly.selected;
});
org.parkerici.blockoid.core.root_block = (function org$parkerici$blockoid$core$root_block(block){
var temp__5733__auto__ = block.getParent();
if(cljs.core.truth_(temp__5733__auto__)){
var parent = temp__5733__auto__;
return org.parkerici.blockoid.core.root_block.call(null,parent);
} else {
return block;
}
});
/**
 * Returns the XML of the selected block group, or the upper left one if none is selected
 */
org.parkerici.blockoid.core.workspace_selected_xml = (function org$parkerici$blockoid$core$workspace_selected_xml(){
var temp__5733__auto__ = org.parkerici.blockoid.core.selected_block.call(null);
if(cljs.core.truth_(temp__5733__auto__)){
var selected = temp__5733__auto__;
return org.parkerici.blockoid.core.block_xml.call(null,org.parkerici.blockoid.core.root_block.call(null,selected));
} else {
return cljs.core.first.call(null,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(org.parkerici.blockoid.core.workspace_xml.call(null)));
}
});
/**
 * Define new block types. Blockdefs is a seq of maps that are converted to JSON as per https://developers.google.com/blockly/guides/configure/web/custom-blocks
 */
org.parkerici.blockoid.core.define_blocks = (function org$parkerici$blockoid$core$define_blocks(blockdefs){
return Blockly.defineBlocksWithJsonArray(cljs.core.clj__GT_js.call(null,blockdefs));
});
if((typeof org !== 'undefined') && (typeof org.parkerici !== 'undefined') && (typeof org.parkerici.blockoid !== 'undefined') && (typeof org.parkerici.blockoid.core !== 'undefined') && (typeof org.parkerici.blockoid.core.toolbox !== 'undefined')){
} else {
/**
 * Translate a toolbox definition form into EDNified XML
 */
org.parkerici.blockoid.core.toolbox = (function (){var method_table__4613__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"org.parkerici.blockoid.core","toolbox"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (p__2599){
var vec__2600 = p__2599;
var seq__2601 = cljs.core.seq.call(null,vec__2600);
var first__2602 = cljs.core.first.call(null,seq__2601);
var seq__2601__$1 = cljs.core.next.call(null,seq__2601);
var type = first__2602;
var _ = seq__2601__$1;
return type;
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"toolbox","toolbox",762819836),(function (p__2603){
var vec__2604 = p__2603;
var seq__2605 = cljs.core.seq.call(null,vec__2604);
var first__2606 = cljs.core.first.call(null,seq__2605);
var seq__2605__$1 = cljs.core.next.call(null,seq__2605);
var _ = first__2606;
var contents = seq__2605__$1;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),"xml",new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,contents)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"category","category",-593092832),(function (p__2607){
var vec__2608 = p__2607;
var seq__2609 = cljs.core.seq.call(null,vec__2608);
var first__2610 = cljs.core.first.call(null,seq__2609);
var seq__2609__$1 = cljs.core.next.call(null,seq__2609);
var _ = first__2610;
var first__2610__$1 = cljs.core.first.call(null,seq__2609__$1);
var seq__2609__$2 = cljs.core.next.call(null,seq__2609__$1);
var name = first__2610__$1;
var first__2610__$2 = cljs.core.first.call(null,seq__2609__$2);
var seq__2609__$3 = cljs.core.next.call(null,seq__2609__$2);
var props = first__2610__$2;
var contents = seq__2609__$3;
var elt = vec__2608;
if((((props == null)) || (cljs.core.map_QMARK_.call(null,props)))){
} else {
throw (new Error(["Assert failed: ",["Can't parse: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(elt)].join(''),"\n","(or (nil? props) (map? props))"].join('')));
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"expanded","expanded",-3020742),true], null),props),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,contents)], null);
}));
org.parkerici.blockoid.core.callback_key = (function org$parkerici$blockoid$core$callback_key(label,handler){
var ckey = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(label),"ButtonHandler"].join('');
cljs.core.swap_BANG_.call(null,org.parkerici.blockoid.core.callback_keys,cljs.core.assoc,ckey,handler);

return ckey;
});
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"button","button",1456579943),(function (p__2611){
var vec__2612 = p__2611;
var _ = cljs.core.nth.call(null,vec__2612,(0),null);
var label = cljs.core.nth.call(null,vec__2612,(1),null);
var event = cljs.core.nth.call(null,vec__2612,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"text","text",-1790561697),label,new cljs.core.Keyword(null,"callbackKey","callbackKey",-478258887),org.parkerici.blockoid.core.callback_key.call(null,label,((function (vec__2612,_,label,event){
return (function (){
return re_frame.core.dispatch.call(null,event);
});})(vec__2612,_,label,event))
)], null)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"block","block",664686210),(function (p__2615){
var vec__2616 = p__2615;
var seq__2617 = cljs.core.seq.call(null,vec__2616);
var first__2618 = cljs.core.first.call(null,seq__2617);
var seq__2617__$1 = cljs.core.next.call(null,seq__2617);
var _ = first__2618;
var first__2618__$1 = cljs.core.first.call(null,seq__2617__$1);
var seq__2617__$2 = cljs.core.next.call(null,seq__2617__$1);
var type = first__2618__$1;
var vec__2619 = seq__2617__$2;
var seq__2620 = cljs.core.seq.call(null,vec__2619);
var first__2621 = cljs.core.first.call(null,seq__2620);
var seq__2620__$1 = cljs.core.next.call(null,seq__2620);
var props = first__2621;
var subs = seq__2620__$1;
var elt = vec__2616;
if((((props == null)) || (cljs.core.map_QMARK_.call(null,props)))){
} else {
throw (new Error(["Assert failed: ",["Can't parse: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(elt)].join(''),"\n","(or (nil? props) (map? props))"].join('')));
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),type], null),props),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,subs)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"field","field",-1302436500),(function (p__2622){
var vec__2623 = p__2622;
var _ = cljs.core.nth.call(null,vec__2623,(0),null);
var name = cljs.core.nth.call(null,vec__2623,(1),null);
var value = cljs.core.nth.call(null,vec__2623,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"value","value",305978217),(function (p__2626){
var vec__2627 = p__2626;
var seq__2628 = cljs.core.seq.call(null,vec__2627);
var first__2629 = cljs.core.first.call(null,seq__2628);
var seq__2628__$1 = cljs.core.next.call(null,seq__2628);
var _ = first__2629;
var first__2629__$1 = cljs.core.first.call(null,seq__2628__$1);
var seq__2628__$2 = cljs.core.next.call(null,seq__2628__$1);
var name = first__2629__$1;
var subs = seq__2628__$2;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,subs)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"next","next",-117701485),(function (p__2630){
var vec__2631 = p__2630;
var _ = cljs.core.nth.call(null,vec__2631,(0),null);
var block = cljs.core.nth.call(null,vec__2631,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"next","next",-117701485),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.parkerici.blockoid.core.toolbox.call(null,block)], null)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"sep","sep",1970430530),(function (p__2634){
var vec__2635 = p__2634;
var seq__2636 = cljs.core.seq.call(null,vec__2635);
var first__2637 = cljs.core.first.call(null,seq__2636);
var seq__2636__$1 = cljs.core.next.call(null,seq__2636);
var _ = first__2637;
var first__2637__$1 = cljs.core.first.call(null,seq__2636__$1);
var seq__2636__$2 = cljs.core.next.call(null,seq__2636__$1);
var ___$1 = first__2637__$1;
var ___$2 = seq__2636__$2;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"sep","sep",1970430530)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"default","default",-1987822328),(function (elt){
return cljs.core.prn.call(null,"No toolbox translation for: ",elt);
}));
/**
 * Turns raw Block XML into compact form
 */
org.parkerici.blockoid.core.compact_1 = (function org$parkerici$blockoid$core$compact_1(ids_QMARK_,block_xml){
if(cljs.core.map_QMARK_.call(null,block_xml)){
var compact = cljs.core.partial.call(null,org.parkerici.blockoid.core.compact_1,ids_QMARK_);
var base = (function (){var G__2638 = cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(block_xml));
switch (G__2638) {
case "xml":
return cljs.core.map.call(null,compact,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml));

break;
case "field":
case "value":
case "statement":
return cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.get_in.call(null,block_xml,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"name","name",1843675177)], null)),compact.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml)))]);

break;
case "next":
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"next","next",-117701485),compact.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml)))], null);

break;
case "block":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.get_in.call(null,block_xml,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"type","type",1174270348)], null)),new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,compact,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml)))], null);

break;
default:
throw cljs.core.ex_info.call(null,"Couldn't interpret Blockly XML",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xml","xml",-1170142052),block_xml], null));

}
})();
var temp__5733__auto__ = (function (){var and__4120__auto__ = ids_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.get_in.call(null,block_xml,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"id","id",-1388402092)], null));
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var id = temp__5733__auto__;
return cljs.core.assoc.call(null,base,new cljs.core.Keyword(null,"id","id",-1388402092),id);
} else {
return base;
}
} else {
return block_xml;
}
});
org.parkerici.blockoid.core.compact = (function org$parkerici$blockoid$core$compact(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2646 = arguments.length;
var i__4731__auto___2647 = (0);
while(true){
if((i__4731__auto___2647 < len__4730__auto___2646)){
args__4736__auto__.push((arguments[i__4731__auto___2647]));

var G__2648 = (i__4731__auto___2647 + (1));
i__4731__auto___2647 = G__2648;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return org.parkerici.blockoid.core.compact.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

org.parkerici.blockoid.core.compact.cljs$core$IFn$_invoke$arity$variadic = (function (block_xml,p__2642){
var vec__2643 = p__2642;
var ids_QMARK_ = cljs.core.nth.call(null,vec__2643,(0),null);
return org.parkerici.blockoid.core.compact_1.call(null,ids_QMARK_,block_xml);
});

org.parkerici.blockoid.core.compact.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
org.parkerici.blockoid.core.compact.cljs$lang$applyTo = (function (seq2640){
var G__2641 = cljs.core.first.call(null,seq2640);
var seq2640__$1 = cljs.core.next.call(null,seq2640);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2641,seq2640__$1);
});


//# sourceMappingURL=core.js.map?rel=1655956417510
