// Compiled by ClojureScript 1.10.520 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR__orig_val__3219 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__3220 = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__3220;

try{try{var seq__3221 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__3222 = null;
var count__3223 = (0);
var i__3224 = (0);
while(true){
if((i__3224 < count__3223)){
var vec__3231 = cljs.core._nth.call(null,chunk__3222,i__3224);
var effect_key = cljs.core.nth.call(null,vec__3231,(0),null);
var effect_value = cljs.core.nth.call(null,vec__3231,(1),null);
var temp__5733__auto___3253 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___3253)){
var effect_fn_3254 = temp__5733__auto___3253;
effect_fn_3254.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__3255 = seq__3221;
var G__3256 = chunk__3222;
var G__3257 = count__3223;
var G__3258 = (i__3224 + (1));
seq__3221 = G__3255;
chunk__3222 = G__3256;
count__3223 = G__3257;
i__3224 = G__3258;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3221);
if(temp__5735__auto__){
var seq__3221__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3221__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__3221__$1);
var G__3259 = cljs.core.chunk_rest.call(null,seq__3221__$1);
var G__3260 = c__4550__auto__;
var G__3261 = cljs.core.count.call(null,c__4550__auto__);
var G__3262 = (0);
seq__3221 = G__3259;
chunk__3222 = G__3260;
count__3223 = G__3261;
i__3224 = G__3262;
continue;
} else {
var vec__3234 = cljs.core.first.call(null,seq__3221__$1);
var effect_key = cljs.core.nth.call(null,vec__3234,(0),null);
var effect_value = cljs.core.nth.call(null,vec__3234,(1),null);
var temp__5733__auto___3263 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___3263)){
var effect_fn_3264 = temp__5733__auto___3263;
effect_fn_3264.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__3265 = cljs.core.next.call(null,seq__3221__$1);
var G__3266 = null;
var G__3267 = (0);
var G__3268 = (0);
seq__3221 = G__3265;
chunk__3222 = G__3266;
count__3223 = G__3267;
i__3224 = G__3268;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__3045__auto___3269 = re_frame.interop.now.call(null);
var duration__3046__auto___3270 = (end__3045__auto___3269 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__3046__auto___3270,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__3045__auto___3269);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__3219;
}} else {
var seq__3237 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__3238 = null;
var count__3239 = (0);
var i__3240 = (0);
while(true){
if((i__3240 < count__3239)){
var vec__3247 = cljs.core._nth.call(null,chunk__3238,i__3240);
var effect_key = cljs.core.nth.call(null,vec__3247,(0),null);
var effect_value = cljs.core.nth.call(null,vec__3247,(1),null);
var temp__5733__auto___3271 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___3271)){
var effect_fn_3272 = temp__5733__auto___3271;
effect_fn_3272.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__3273 = seq__3237;
var G__3274 = chunk__3238;
var G__3275 = count__3239;
var G__3276 = (i__3240 + (1));
seq__3237 = G__3273;
chunk__3238 = G__3274;
count__3239 = G__3275;
i__3240 = G__3276;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3237);
if(temp__5735__auto__){
var seq__3237__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3237__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__3237__$1);
var G__3277 = cljs.core.chunk_rest.call(null,seq__3237__$1);
var G__3278 = c__4550__auto__;
var G__3279 = cljs.core.count.call(null,c__4550__auto__);
var G__3280 = (0);
seq__3237 = G__3277;
chunk__3238 = G__3278;
count__3239 = G__3279;
i__3240 = G__3280;
continue;
} else {
var vec__3250 = cljs.core.first.call(null,seq__3237__$1);
var effect_key = cljs.core.nth.call(null,vec__3250,(0),null);
var effect_value = cljs.core.nth.call(null,vec__3250,(1),null);
var temp__5733__auto___3281 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5733__auto___3281)){
var effect_fn_3282 = temp__5733__auto___3281;
effect_fn_3282.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__3283 = cljs.core.next.call(null,seq__3237__$1);
var G__3284 = null;
var G__3285 = (0);
var G__3286 = (0);
seq__3237 = G__3283;
chunk__3238 = G__3284;
count__3239 = G__3285;
i__3240 = G__3286;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__3287 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__3288 = null;
var count__3289 = (0);
var i__3290 = (0);
while(true){
if((i__3290 < count__3289)){
var map__3295 = cljs.core._nth.call(null,chunk__3288,i__3290);
var map__3295__$1 = (((((!((map__3295 == null))))?(((((map__3295.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3295.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3295):map__3295);
var effect = map__3295__$1;
var ms = cljs.core.get.call(null,map__3295__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__3295__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__3287,chunk__3288,count__3289,i__3290,map__3295,map__3295__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__3287,chunk__3288,count__3289,i__3290,map__3295,map__3295__$1,effect,ms,dispatch))
,ms);
}


var G__3299 = seq__3287;
var G__3300 = chunk__3288;
var G__3301 = count__3289;
var G__3302 = (i__3290 + (1));
seq__3287 = G__3299;
chunk__3288 = G__3300;
count__3289 = G__3301;
i__3290 = G__3302;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3287);
if(temp__5735__auto__){
var seq__3287__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3287__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__3287__$1);
var G__3303 = cljs.core.chunk_rest.call(null,seq__3287__$1);
var G__3304 = c__4550__auto__;
var G__3305 = cljs.core.count.call(null,c__4550__auto__);
var G__3306 = (0);
seq__3287 = G__3303;
chunk__3288 = G__3304;
count__3289 = G__3305;
i__3290 = G__3306;
continue;
} else {
var map__3297 = cljs.core.first.call(null,seq__3287__$1);
var map__3297__$1 = (((((!((map__3297 == null))))?(((((map__3297.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3297.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3297):map__3297);
var effect = map__3297__$1;
var ms = cljs.core.get.call(null,map__3297__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__3297__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__3287,chunk__3288,count__3289,i__3290,map__3297,map__3297__$1,effect,ms,dispatch,seq__3287__$1,temp__5735__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__3287,chunk__3288,count__3289,i__3290,map__3297,map__3297__$1,effect,ms,dispatch,seq__3287__$1,temp__5735__auto__))
,ms);
}


var G__3307 = cljs.core.next.call(null,seq__3287__$1);
var G__3308 = null;
var G__3309 = (0);
var G__3310 = (0);
seq__3287 = G__3307;
chunk__3288 = G__3308;
count__3289 = G__3309;
i__3290 = G__3310;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value);
} else {
var seq__3311 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__3312 = null;
var count__3313 = (0);
var i__3314 = (0);
while(true){
if((i__3314 < count__3313)){
var event = cljs.core._nth.call(null,chunk__3312,i__3314);
re_frame.router.dispatch.call(null,event);


var G__3315 = seq__3311;
var G__3316 = chunk__3312;
var G__3317 = count__3313;
var G__3318 = (i__3314 + (1));
seq__3311 = G__3315;
chunk__3312 = G__3316;
count__3313 = G__3317;
i__3314 = G__3318;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3311);
if(temp__5735__auto__){
var seq__3311__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3311__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__3311__$1);
var G__3319 = cljs.core.chunk_rest.call(null,seq__3311__$1);
var G__3320 = c__4550__auto__;
var G__3321 = cljs.core.count.call(null,c__4550__auto__);
var G__3322 = (0);
seq__3311 = G__3319;
chunk__3312 = G__3320;
count__3313 = G__3321;
i__3314 = G__3322;
continue;
} else {
var event = cljs.core.first.call(null,seq__3311__$1);
re_frame.router.dispatch.call(null,event);


var G__3323 = cljs.core.next.call(null,seq__3311__$1);
var G__3324 = null;
var G__3325 = (0);
var G__3326 = (0);
seq__3311 = G__3323;
chunk__3312 = G__3324;
count__3313 = G__3325;
i__3314 = G__3326;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__3327 = cljs.core.seq.call(null,value);
var chunk__3328 = null;
var count__3329 = (0);
var i__3330 = (0);
while(true){
if((i__3330 < count__3329)){
var event = cljs.core._nth.call(null,chunk__3328,i__3330);
clear_event.call(null,event);


var G__3331 = seq__3327;
var G__3332 = chunk__3328;
var G__3333 = count__3329;
var G__3334 = (i__3330 + (1));
seq__3327 = G__3331;
chunk__3328 = G__3332;
count__3329 = G__3333;
i__3330 = G__3334;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__3327);
if(temp__5735__auto__){
var seq__3327__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3327__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__3327__$1);
var G__3335 = cljs.core.chunk_rest.call(null,seq__3327__$1);
var G__3336 = c__4550__auto__;
var G__3337 = cljs.core.count.call(null,c__4550__auto__);
var G__3338 = (0);
seq__3327 = G__3335;
chunk__3328 = G__3336;
count__3329 = G__3337;
i__3330 = G__3338;
continue;
} else {
var event = cljs.core.first.call(null,seq__3327__$1);
clear_event.call(null,event);


var G__3339 = cljs.core.next.call(null,seq__3327__$1);
var G__3340 = null;
var G__3341 = (0);
var G__3342 = (0);
seq__3327 = G__3339;
chunk__3328 = G__3340;
count__3329 = G__3341;
i__3330 = G__3342;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref.call(null,re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1655950700632
