// Compiled by ClojureScript 1.10.520 {}
goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.call(null,(0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_.call(null,re_frame.trace.id,(0));
});

/** @define {boolean} */
goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.call(null,(0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-10x#installation.");
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.call(null,re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.call(null,re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__3067){
var map__3068 = p__3067;
var map__3068__$1 = (((((!((map__3068 == null))))?(((((map__3068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3068.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3068):map__3068);
var operation = cljs.core.get.call(null,map__3068__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.call(null,map__3068__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.call(null,map__3068__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.call(null,map__3068__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id.call(null),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4131__auto__ = child_of;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now.call(null)], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce.call(null,(function re_frame$trace$tracing_cb_debounced(){
var seq__3070_3090 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__3071_3091 = null;
var count__3072_3092 = (0);
var i__3073_3093 = (0);
while(true){
if((i__3073_3093 < count__3072_3092)){
var vec__3082_3094 = cljs.core._nth.call(null,chunk__3071_3091,i__3073_3093);
var k_3095 = cljs.core.nth.call(null,vec__3082_3094,(0),null);
var cb_3096 = cljs.core.nth.call(null,vec__3082_3094,(1),null);
try{cb_3096.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e3085){var e_3097 = e3085;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_3095,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_3097);
}

var G__3098 = seq__3070_3090;
var G__3099 = chunk__3071_3091;
var G__3100 = count__3072_3092;
var G__3101 = (i__3073_3093 + (1));
seq__3070_3090 = G__3098;
chunk__3071_3091 = G__3099;
count__3072_3092 = G__3100;
i__3073_3093 = G__3101;
continue;
} else {
var temp__5735__auto___3102 = cljs.core.seq.call(null,seq__3070_3090);
if(temp__5735__auto___3102){
var seq__3070_3103__$1 = temp__5735__auto___3102;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__3070_3103__$1)){
var c__4550__auto___3104 = cljs.core.chunk_first.call(null,seq__3070_3103__$1);
var G__3105 = cljs.core.chunk_rest.call(null,seq__3070_3103__$1);
var G__3106 = c__4550__auto___3104;
var G__3107 = cljs.core.count.call(null,c__4550__auto___3104);
var G__3108 = (0);
seq__3070_3090 = G__3105;
chunk__3071_3091 = G__3106;
count__3072_3092 = G__3107;
i__3073_3093 = G__3108;
continue;
} else {
var vec__3086_3109 = cljs.core.first.call(null,seq__3070_3103__$1);
var k_3110 = cljs.core.nth.call(null,vec__3086_3109,(0),null);
var cb_3111 = cljs.core.nth.call(null,vec__3086_3109,(1),null);
try{cb_3111.call(null,cljs.core.deref.call(null,re_frame.trace.traces));
}catch (e3089){var e_3112 = e3089;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k_3110,"while storing",cljs.core.deref.call(null,re_frame.trace.traces),e_3112);
}

var G__3113 = cljs.core.next.call(null,seq__3070_3103__$1);
var G__3114 = null;
var G__3115 = (0);
var G__3116 = (0);
seq__3070_3090 = G__3113;
chunk__3071_3091 = G__3114;
count__3072_3092 = G__3115;
i__3073_3093 = G__3116;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref.call(null,re_frame.trace.next_delivery) - (25)) < now)){
re_frame.trace.schedule_debounce.call(null);

return cljs.core.reset_BANG_.call(null,re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=trace.js.map?rel=1655950700329
