// Compiled by ClojureScript 1.10.520 {}
goog.provide('org.parkerici.blockoid.core');
goog.require('cljs.core');
goog.require('cljsjs.blockly');
goog.require('cljsjs.blockly.blocks');
goog.require('clojure.data.xml');
org.parkerici.blockoid.core.workspace = cljs.core.atom.call(null,null);
org.parkerici.blockoid.core.blockly_div = cljs.core.atom.call(null,null);
org.parkerici.blockoid.core.callback_keys = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Initialize Blockly. Args:
 *   div:  Name of the HTML div element in which to inject Blockly
 *  toolbox-xml: XML in EDN format. Usually generated by `toolbox`. 
 *  options: map of additional options to `inject`, eg: `{:zoom true}`. See https://developers.google.com/blockly/guides/get-started/web#configuration
 * 
 *  change-handler: a fn of one argument (event) that gets called on any changes to the workspace. 
 */
org.parkerici.blockoid.core.define_workspace = (function org$parkerici$blockoid$core$define_workspace(div,toolbox_xml,options,change_handler){
cljs.core.reset_BANG_.call(null,org.parkerici.blockoid.core.workspace,Blockly.inject(div,cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"toolbox","toolbox",762819836),clojure.data.xml.emit_str.call(null,toolbox_xml)], null),options))));

cljs.core.reset_BANG_.call(null,org.parkerici.blockoid.core.blockly_div,div);

var seq__1754_1770 = cljs.core.seq.call(null,cljs.core.deref.call(null,org.parkerici.blockoid.core.callback_keys));
var chunk__1755_1771 = null;
var count__1756_1772 = (0);
var i__1757_1773 = (0);
while(true){
if((i__1757_1773 < count__1756_1772)){
var vec__1764_1774 = cljs.core._nth.call(null,chunk__1755_1771,i__1757_1773);
var ckey_1775 = cljs.core.nth.call(null,vec__1764_1774,(0),null);
var handler_1776 = cljs.core.nth.call(null,vec__1764_1774,(1),null);
cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).registerButtonCallback(ckey_1775,handler_1776);


var G__1777 = seq__1754_1770;
var G__1778 = chunk__1755_1771;
var G__1779 = count__1756_1772;
var G__1780 = (i__1757_1773 + (1));
seq__1754_1770 = G__1777;
chunk__1755_1771 = G__1778;
count__1756_1772 = G__1779;
i__1757_1773 = G__1780;
continue;
} else {
var temp__5735__auto___1781 = cljs.core.seq.call(null,seq__1754_1770);
if(temp__5735__auto___1781){
var seq__1754_1782__$1 = temp__5735__auto___1781;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__1754_1782__$1)){
var c__4550__auto___1783 = cljs.core.chunk_first.call(null,seq__1754_1782__$1);
var G__1784 = cljs.core.chunk_rest.call(null,seq__1754_1782__$1);
var G__1785 = c__4550__auto___1783;
var G__1786 = cljs.core.count.call(null,c__4550__auto___1783);
var G__1787 = (0);
seq__1754_1770 = G__1784;
chunk__1755_1771 = G__1785;
count__1756_1772 = G__1786;
i__1757_1773 = G__1787;
continue;
} else {
var vec__1767_1788 = cljs.core.first.call(null,seq__1754_1782__$1);
var ckey_1789 = cljs.core.nth.call(null,vec__1767_1788,(0),null);
var handler_1790 = cljs.core.nth.call(null,vec__1767_1788,(1),null);
cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).registerButtonCallback(ckey_1789,handler_1790);


var G__1791 = cljs.core.next.call(null,seq__1754_1782__$1);
var G__1792 = null;
var G__1793 = (0);
var G__1794 = (0);
seq__1754_1770 = G__1791;
chunk__1755_1771 = G__1792;
count__1756_1772 = G__1793;
i__1757_1773 = G__1794;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).addChangeListener(change_handler);
});
/**
 * Update the toolbox, keeping workspace the same (warning: dangerous)
 */
org.parkerici.blockoid.core.update_toolbox = (function org$parkerici$blockoid$core$update_toolbox(toolbox_def){
return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).updateToolbox(clojure.data.xml.emit_str.call(null,toolbox_def));
});
org.parkerici.blockoid.core.area_div = cljs.core.atom.call(null,null);
/**
 * Compute the absolute coordinates and dimensions of blocklyArea
 */
org.parkerici.blockoid.core.on_resize = (function org$parkerici$blockoid$core$on_resize(_){
var blockly_area = document.getElementById(cljs.core.deref.call(null,org.parkerici.blockoid.core.area_div));
var blockly_div = document.getElementById(cljs.core.deref.call(null,org.parkerici.blockoid.core.blockly_div));
var element = blockly_area;
var x = (0);
var y = (0);
while(true){
if(cljs.core.truth_(element)){
var G__1795 = element.offsetParent;
var G__1796 = (x + element.offsetLeft);
var G__1797 = (y + element.offsetTop);
element = G__1795;
x = G__1796;
y = G__1797;
continue;
} else {
blockly_div.style.left = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"px"].join('');

blockly_div.style.top = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(y),"px"].join('');

blockly_div.style.width = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(blockly_area.offsetWidth),"px"].join('');

blockly_div.style.height = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(blockly_area.offsetHeight),"px"].join('');

return Blockly.svgResize(cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace));
}
break;
}
});
/**
 * Call this after `define-workspace` to enable automatic resizing
 */
org.parkerici.blockoid.core.auto_resize_workspace = (function org$parkerici$blockoid$core$auto_resize_workspace(div){
cljs.core.reset_BANG_.call(null,org.parkerici.blockoid.core.area_div,div);

window.addEventListener("resize",org.parkerici.blockoid.core.on_resize,false);

return org.parkerici.blockoid.core.on_resize.call(null,null);
});
org.parkerici.blockoid.core.block_xml_string = (function org$parkerici$blockoid$core$block_xml_string(block){
return Blockly.Xml.domToText(Blockly.Xml.blockToDom(block));
});
org.parkerici.blockoid.core.block_xml = (function org$parkerici$blockoid$core$block_xml(block){
return clojure.data.xml.parse_str.call(null,org.parkerici.blockoid.core.block_xml_string.call(null,block));
});
org.parkerici.blockoid.core.workspace_xml_string = (function org$parkerici$blockoid$core$workspace_xml_string(){
return Blockly.Xml.domToText(Blockly.Xml.workspaceToDom(cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace)));
});
org.parkerici.blockoid.core.workspace_xml = (function org$parkerici$blockoid$core$workspace_xml(){
return clojure.data.xml.parse_str.call(null,org.parkerici.blockoid.core.workspace_xml_string.call(null));
});
org.parkerici.blockoid.core.clear_workspace = (function org$parkerici$blockoid$core$clear_workspace(){
return cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace).clear();
});
org.parkerici.blockoid.core.encode_xml = (function org$parkerici$blockoid$core$encode_xml(xml){
var xml_string = clojure.data.xml.emit_str.call(null,xml);
return Blockly.Xml.textToDom(xml_string);
});
org.parkerici.blockoid.core.set_workspace_xml = (function org$parkerici$blockoid$core$set_workspace_xml(xml){
var dom = org.parkerici.blockoid.core.encode_xml.call(null,xml);
org.parkerici.blockoid.core.clear_workspace.call(null);

return Blockly.Xml.domToWorkspace(dom,cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace));
});
org.parkerici.blockoid.core.add_workspace_xml = (function org$parkerici$blockoid$core$add_workspace_xml(xml){
var dom = org.parkerici.blockoid.core.encode_xml.call(null,xml);
return Blockly.Xml.appendDomToWorkspace(dom,cljs.core.deref.call(null,org.parkerici.blockoid.core.workspace));
});
org.parkerici.blockoid.core.selected_block = (function org$parkerici$blockoid$core$selected_block(){
return Blockly.selected;
});
org.parkerici.blockoid.core.root_block = (function org$parkerici$blockoid$core$root_block(block){
var temp__5733__auto__ = block.getParent();
if(cljs.core.truth_(temp__5733__auto__)){
var parent = temp__5733__auto__;
return org.parkerici.blockoid.core.root_block.call(null,parent);
} else {
return block;
}
});
/**
 * Returns the XML of the selected block group, or the upper left one if none is selected
 */
org.parkerici.blockoid.core.workspace_selected_xml = (function org$parkerici$blockoid$core$workspace_selected_xml(){
var temp__5733__auto__ = org.parkerici.blockoid.core.selected_block.call(null);
if(cljs.core.truth_(temp__5733__auto__)){
var selected = temp__5733__auto__;
return org.parkerici.blockoid.core.block_xml.call(null,org.parkerici.blockoid.core.root_block.call(null,selected));
} else {
return cljs.core.first.call(null,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(org.parkerici.blockoid.core.workspace_xml.call(null)));
}
});
/**
 * Define new block types. Blockdefs is a seq of maps that are converted to JSON as per https://developers.google.com/blockly/guides/configure/web/custom-blocks
 */
org.parkerici.blockoid.core.define_blocks = (function org$parkerici$blockoid$core$define_blocks(blockdefs){
return Blockly.defineBlocksWithJsonArray(cljs.core.clj__GT_js.call(null,blockdefs));
});
if((typeof org !== 'undefined') && (typeof org.parkerici !== 'undefined') && (typeof org.parkerici.blockoid !== 'undefined') && (typeof org.parkerici.blockoid.core !== 'undefined') && (typeof org.parkerici.blockoid.core.toolbox !== 'undefined')){
} else {
/**
 * Translate a toolbox definition form into EDNified XML
 */
org.parkerici.blockoid.core.toolbox = (function (){var method_table__4613__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4614__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4615__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4616__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4617__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"org.parkerici.blockoid.core","toolbox"),((function (method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__){
return (function (p__1798){
var vec__1799 = p__1798;
var seq__1800 = cljs.core.seq.call(null,vec__1799);
var first__1801 = cljs.core.first.call(null,seq__1800);
var seq__1800__$1 = cljs.core.next.call(null,seq__1800);
var type = first__1801;
var _ = seq__1800__$1;
return type;
});})(method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__,hierarchy__4617__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4617__auto__,method_table__4613__auto__,prefer_table__4614__auto__,method_cache__4615__auto__,cached_hierarchy__4616__auto__));
})();
}
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"toolbox","toolbox",762819836),(function (p__1802){
var vec__1803 = p__1802;
var seq__1804 = cljs.core.seq.call(null,vec__1803);
var first__1805 = cljs.core.first.call(null,seq__1804);
var seq__1804__$1 = cljs.core.next.call(null,seq__1804);
var _ = first__1805;
var contents = seq__1804__$1;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),"xml",new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,contents)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"category","category",-593092832),(function (p__1806){
var vec__1807 = p__1806;
var seq__1808 = cljs.core.seq.call(null,vec__1807);
var first__1809 = cljs.core.first.call(null,seq__1808);
var seq__1808__$1 = cljs.core.next.call(null,seq__1808);
var _ = first__1809;
var first__1809__$1 = cljs.core.first.call(null,seq__1808__$1);
var seq__1808__$2 = cljs.core.next.call(null,seq__1808__$1);
var name = first__1809__$1;
var first__1809__$2 = cljs.core.first.call(null,seq__1808__$2);
var seq__1808__$3 = cljs.core.next.call(null,seq__1808__$2);
var props = first__1809__$2;
var contents = seq__1808__$3;
var elt = vec__1807;
if((((props == null)) || (cljs.core.map_QMARK_.call(null,props)))){
} else {
throw (new Error(["Assert failed: ",["Can't parse: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(elt)].join(''),"\n","(or (nil? props) (map? props))"].join('')));
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"category","category",-593092832),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"expanded","expanded",-3020742),true], null),props),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,contents)], null);
}));
org.parkerici.blockoid.core.callback_key = (function org$parkerici$blockoid$core$callback_key(label,handler){
var ckey = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(label),"ButtonHandler"].join('');
cljs.core.swap_BANG_.call(null,org.parkerici.blockoid.core.callback_keys,cljs.core.assoc,ckey,handler);

return ckey;
});
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"button","button",1456579943),(function (p__1810){
var vec__1811 = p__1810;
var _ = cljs.core.nth.call(null,vec__1811,(0),null);
var label = cljs.core.nth.call(null,vec__1811,(1),null);
var handler = cljs.core.nth.call(null,vec__1811,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"text","text",-1790561697),label,new cljs.core.Keyword(null,"callbackKey","callbackKey",-478258887),org.parkerici.blockoid.core.callback_key.call(null,label,handler)], null)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"block","block",664686210),(function (p__1814){
var vec__1815 = p__1814;
var seq__1816 = cljs.core.seq.call(null,vec__1815);
var first__1817 = cljs.core.first.call(null,seq__1816);
var seq__1816__$1 = cljs.core.next.call(null,seq__1816);
var _ = first__1817;
var first__1817__$1 = cljs.core.first.call(null,seq__1816__$1);
var seq__1816__$2 = cljs.core.next.call(null,seq__1816__$1);
var type = first__1817__$1;
var vec__1818 = seq__1816__$2;
var seq__1819 = cljs.core.seq.call(null,vec__1818);
var first__1820 = cljs.core.first.call(null,seq__1819);
var seq__1819__$1 = cljs.core.next.call(null,seq__1819);
var props = first__1820;
var subs = seq__1819__$1;
var elt = vec__1815;
if((((props == null)) || (cljs.core.map_QMARK_.call(null,props)))){
} else {
throw (new Error(["Assert failed: ",["Can't parse: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(elt)].join(''),"\n","(or (nil? props) (map? props))"].join('')));
}

return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),type], null),props),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,subs)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"field","field",-1302436500),(function (p__1821){
var vec__1822 = p__1821;
var _ = cljs.core.nth.call(null,vec__1822,(0),null);
var name = cljs.core.nth.call(null,vec__1822,(1),null);
var value = cljs.core.nth.call(null,vec__1822,(2),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"value","value",305978217),(function (p__1825){
var vec__1826 = p__1825;
var seq__1827 = cljs.core.seq.call(null,vec__1826);
var first__1828 = cljs.core.first.call(null,seq__1827);
var seq__1827__$1 = cljs.core.next.call(null,seq__1827);
var _ = first__1828;
var first__1828__$1 = cljs.core.first.call(null,seq__1827__$1);
var seq__1827__$2 = cljs.core.next.call(null,seq__1827__$1);
var name = first__1828__$1;
var subs = seq__1827__$2;
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),new cljs.core.Keyword(null,"content","content",15833224),cljs.core.mapv.call(null,org.parkerici.blockoid.core.toolbox,subs)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"next","next",-117701485),(function (p__1829){
var vec__1830 = p__1829;
var _ = cljs.core.nth.call(null,vec__1830,(0),null);
var block = cljs.core.nth.call(null,vec__1830,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"next","next",-117701485),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.parkerici.blockoid.core.toolbox.call(null,block)], null)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"sep","sep",1970430530),(function (p__1833){
var vec__1834 = p__1833;
var seq__1835 = cljs.core.seq.call(null,vec__1834);
var first__1836 = cljs.core.first.call(null,seq__1835);
var seq__1835__$1 = cljs.core.next.call(null,seq__1835);
var _ = first__1836;
var first__1836__$1 = cljs.core.first.call(null,seq__1835__$1);
var seq__1835__$2 = cljs.core.next.call(null,seq__1835__$1);
var ___$1 = first__1836__$1;
var ___$2 = seq__1835__$2;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"sep","sep",1970430530)], null);
}));
cljs.core._add_method.call(null,org.parkerici.blockoid.core.toolbox,new cljs.core.Keyword(null,"default","default",-1987822328),(function (elt){
return cljs.core.prn.call(null,"No toolbox translation for: ",elt);
}));
/**
 * Turns raw Block XML into compact form
 */
org.parkerici.blockoid.core.compact = (function org$parkerici$blockoid$core$compact(block_xml){
if(cljs.core.map_QMARK_.call(null,block_xml)){
var G__1837 = cljs.core.name.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223).cljs$core$IFn$_invoke$arity$1(block_xml));
switch (G__1837) {
case "xml":
return cljs.core.map.call(null,org.parkerici.blockoid.core.compact,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml));

break;
case "field":
case "value":
case "statement":
return cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.get_in.call(null,block_xml,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"name","name",1843675177)], null)),org.parkerici.blockoid.core.compact.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml)))]);

break;
case "next":
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"next","next",-117701485),org.parkerici.blockoid.core.compact.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml)))], null);

break;
case "block":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.get_in.call(null,block_xml,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"type","type",1174270348)], null)),new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,org.parkerici.blockoid.core.compact,new cljs.core.Keyword(null,"content","content",15833224).cljs$core$IFn$_invoke$arity$1(block_xml)))], null);

break;
default:
throw cljs.core.ex_info.call(null,"Couldn't interpret Blockly XML",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xml","xml",-1170142052),block_xml], null));

}
} else {
return block_xml;
}
});

//# sourceMappingURL=core.js.map?rel=1584937030947
