(ns clj-kondo.etaoin.api
  (:require
   [clj-kondo.hooks-api :as api]))

(defn with-chrome
  [{{:keys [children]} :node}]
  (let [opts+driver (butlast (rest children))
        body (last children)
        [opts driver] (if (= 1 (count opts+driver))
                        (into [(api/map-node {})] opts+driver)
                        opts+driver)]
    {:node
     (api/list-node
      [(api/token-node 'let)
       (api/vector-node [driver opts])
       body])}))
