/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SearcherWarmer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ThreadInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NRTManager
implements Closeable {
    private static final long MAX_SEARCHER_GEN = Long.MAX_VALUE;
    private final IndexWriter writer;
    private final SearcherManagerRef withoutDeletes;
    private final SearcherManagerRef withDeletes;
    private final AtomicLong indexingGen;
    private final List<WaitingListener> waitingListeners = new CopyOnWriteArrayList<WaitingListener>();
    private final ReentrantLock reopenLock = new ReentrantLock();
    private final Condition newGeneration = this.reopenLock.newCondition();

    public NRTManager(IndexWriter writer, SearcherWarmer warmer) throws IOException {
        this(writer, null, warmer, true);
    }

    public NRTManager(IndexWriter writer, ExecutorService es, SearcherWarmer warmer) throws IOException {
        this(writer, es, warmer, true);
    }

    public NRTManager(IndexWriter writer, ExecutorService es, SearcherWarmer warmer, boolean alwaysApplyDeletes) throws IOException {
        this.writer = writer;
        if (alwaysApplyDeletes) {
            this.withoutDeletes = this.withDeletes = new SearcherManagerRef(true, 0L, new SearcherManager(writer, true, warmer, es));
        } else {
            this.withDeletes = new SearcherManagerRef(true, 0L, new SearcherManager(writer, true, warmer, es));
            this.withoutDeletes = new SearcherManagerRef(false, 0L, new SearcherManager(writer, false, warmer, es));
        }
        this.indexingGen = new AtomicLong(1L);
    }

    public void addWaitingListener(WaitingListener l) {
        this.waitingListeners.add(l);
    }

    public void removeWaitingListener(WaitingListener l) {
        this.waitingListeners.remove(l);
    }

    public long updateDocument(Term t, Document d, Analyzer a) throws IOException {
        this.writer.updateDocument(t, d, a);
        return this.indexingGen.get();
    }

    public long updateDocument(Term t, Document d) throws IOException {
        this.writer.updateDocument(t, d);
        return this.indexingGen.get();
    }

    public long updateDocuments(Term t, Collection<Document> docs, Analyzer a) throws IOException {
        this.writer.updateDocuments(t, docs, a);
        return this.indexingGen.get();
    }

    public long updateDocuments(Term t, Collection<Document> docs) throws IOException {
        this.writer.updateDocuments(t, docs);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Term t) throws IOException {
        this.writer.deleteDocuments(t);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Term ... terms) throws IOException {
        this.writer.deleteDocuments(terms);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Query q) throws IOException {
        this.writer.deleteDocuments(q);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Query ... queries) throws IOException {
        this.writer.deleteDocuments(queries);
        return this.indexingGen.get();
    }

    public long deleteAll() throws IOException {
        this.writer.deleteAll();
        return this.indexingGen.get();
    }

    public long addDocument(Document d, Analyzer a) throws IOException {
        this.writer.addDocument(d, a);
        return this.indexingGen.get();
    }

    public long addDocuments(Collection<Document> docs, Analyzer a) throws IOException {
        this.writer.addDocuments(docs, a);
        return this.indexingGen.get();
    }

    public long addDocument(Document d) throws IOException {
        this.writer.addDocument(d);
        return this.indexingGen.get();
    }

    public long addDocuments(Collection<Document> docs) throws IOException {
        this.writer.addDocuments(docs);
        return this.indexingGen.get();
    }

    public long addIndexes(Directory ... dirs) throws CorruptIndexException, IOException {
        this.writer.addIndexes(dirs);
        return this.indexingGen.get();
    }

    public long addIndexes(IndexReader ... readers) throws CorruptIndexException, IOException {
        this.writer.addIndexes(readers);
        return this.indexingGen.get();
    }

    public SearcherManager waitForGeneration(long targetGen, boolean requireDeletes) {
        return this.waitForGeneration(targetGen, requireDeletes, -1L, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearcherManager waitForGeneration(long targetGen, boolean requireDeletes, long time, TimeUnit unit) {
        try {
            long curGen = this.indexingGen.get();
            if (targetGen > curGen) {
                throw new IllegalArgumentException("targetGen=" + targetGen + " was never returned by this NRTManager instance (current gen=" + curGen + ")");
            }
            this.reopenLock.lockInterruptibly();
            try {
                if (targetGen > this.getCurrentSearchingGen(requireDeletes)) {
                    for (WaitingListener listener : this.waitingListeners) {
                        listener.waiting(requireDeletes, targetGen);
                    }
                    while (targetGen > this.getCurrentSearchingGen(requireDeletes)) {
                        if (this.waitOnGenCondition(time, unit)) continue;
                        SearcherManager searcherManager = this.getSearcherManager(requireDeletes);
                        Object var12_8 = null;
                        this.reopenLock.unlock();
                        return searcherManager;
                    }
                }
                Object var12_9 = null;
                this.reopenLock.unlock();
                return this.getSearcherManager(requireDeletes);
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                this.reopenLock.unlock();
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    private boolean waitOnGenCondition(long time, TimeUnit unit) throws InterruptedException {
        assert (this.reopenLock.isHeldByCurrentThread());
        if (time < 0L) {
            this.newGeneration.await();
            return true;
        }
        return this.newGeneration.await(time, unit);
    }

    public long getCurrentSearchingGen(boolean applyAllDeletes) {
        if (applyAllDeletes) {
            return this.withDeletes.generation;
        }
        return Math.max(this.withoutDeletes.generation, this.withDeletes.generation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeReopen(boolean applyAllDeletes) throws IOException {
        if (this.reopenLock.tryLock()) {
            boolean setSearchGen;
            long newSearcherGen;
            SearcherManagerRef reference;
            block6: {
                try {
                    reference = applyAllDeletes ? this.withDeletes : this.withoutDeletes;
                    newSearcherGen = this.indexingGen.getAndIncrement();
                    setSearchGen = false;
                    if (reference.generation != Long.MAX_VALUE) break block6;
                    this.newGeneration.signalAll();
                    boolean bl = false;
                    Object var8_7 = null;
                    this.reopenLock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.reopenLock.unlock();
                    throw throwable;
                }
            }
            setSearchGen = reference.manager.isSearcherCurrent();
            if (!setSearchGen) {
                setSearchGen = reference.manager.maybeReopen();
            }
            if (setSearchGen) {
                reference.generation = newSearcherGen;
                this.newGeneration.signalAll();
            }
            boolean bl = setSearchGen;
            Object var8_8 = null;
            this.reopenLock.unlock();
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        this.reopenLock.lock();
        try {
            try {
                IOUtils.close(this.withDeletes, this.withoutDeletes);
                Object var2_1 = null;
                this.newGeneration.signalAll();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.newGeneration.signalAll();
                throw throwable;
            }
            Object var4_4 = null;
            this.reopenLock.unlock();
            if ($assertionsDisabled || this.withDeletes.generation == Long.MAX_VALUE && this.withoutDeletes.generation == Long.MAX_VALUE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.reopenLock.unlock();
            if ($assertionsDisabled || this.withDeletes.generation == Long.MAX_VALUE && this.withoutDeletes.generation == Long.MAX_VALUE) throw throwable;
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    public SearcherManager getSearcherManager(boolean applyAllDeletes) {
        if (applyAllDeletes) {
            return this.withDeletes.manager;
        }
        if (this.withDeletes.generation > this.withoutDeletes.generation) {
            return this.withDeletes.manager;
        }
        return this.withoutDeletes.manager;
    }

    static final class SearcherManagerRef
    implements Closeable {
        final boolean applyDeletes;
        volatile long generation;
        final SearcherManager manager;

        SearcherManagerRef(boolean applyDeletes, long generation, SearcherManager manager) {
            this.applyDeletes = applyDeletes;
            this.generation = generation;
            this.manager = manager;
        }

        public void close() throws IOException {
            this.generation = Long.MAX_VALUE;
            this.manager.close();
        }
    }

    public static interface WaitingListener {
        public void waiting(boolean var1, long var2);
    }
}

